/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.api.events.battles.BagItemEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class BagPacket
extends AbstractPixelmonPacket {
    private ItemStack usedStack;
    private int battleIndex;
    private int additionalInfo;
    private UUID pokemonUUID;
    private UUID targetPokemonUUID;
    public boolean fromPokemon;

    public BagPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public BagPacket(UUID pokemonUUID, ItemStack usedStack, int battleIndex, int additionalInfo) {
        super(PacketDirection.PLAY_SERVER, true);
        this.fromPokemon = false;
        this.pokemonUUID = pokemonUUID;
        this.usedStack = usedStack;
        this.battleIndex = battleIndex;
        this.additionalInfo = additionalInfo;
    }

    public BagPacket(UUID pokemonUUID, UUID targetPokemonUUID, ItemStack usedStack, int battleIndex) {
        super(PacketDirection.PLAY_SERVER, true);
        this.fromPokemon = true;
        this.pokemonUUID = pokemonUUID;
        this.targetPokemonUUID = targetPokemonUUID;
        this.usedStack = usedStack;
        this.battleIndex = battleIndex;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.fromPokemon = buffer.readBoolean();
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        int count = buffer.readInt();
        this.usedStack = buffer.m_130267_();
        this.usedStack.m_41764_(count);
        this.battleIndex = buffer.readInt();
        if (!this.fromPokemon) {
            this.additionalInfo = buffer.readInt();
        } else {
            this.targetPokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.fromPokemon);
        buffer.m_130077_(this.pokemonUUID);
        buffer.writeInt(this.usedStack.m_41613_());
        this.usedStack.m_41764_(64);
        buffer.writeItemStack(this.usedStack, false);
        buffer.writeInt(this.battleIndex);
        if (!this.fromPokemon) {
            buffer.writeInt(this.additionalInfo);
        } else {
            buffer.m_130077_(this.targetPokemonUUID);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        context.getSender().m_9243_();
        this.bagPacket(context.getSender());
    }

    private void bagPacket(ServerPlayer player) {
        ItemStack usedStack;
        BattleController bc = BattleRegistry.getBattle(this.battleIndex);
        BagItemEvent.SelectItem.Pre pre = new BagItemEvent.SelectItem.Pre(bc, "", player, this.usedStack, usedStack = BattleItemScanner.findMatchingItem(this.usedStack, player));
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        usedStack = pre.getFoundItem();
        if (usedStack == null) {
            ChatHandler.sendChat((Entity)player, "bagpacket.itemnotfound", new Object[0]);
            return;
        }
        if (bc == null) {
            ChatHandler.sendChat((Entity)player, "bagpacket.battlenotfound", new Object[0]);
            return;
        }
        if (!this.fromPokemon && bc.isWaiting()) {
            bc.setUseItem(this.pokemonUUID, (Player)player, usedStack, this.additionalInfo);
        } else {
            bc.setUseItem(this.pokemonUUID, (Player)player, usedStack, this.targetPokemonUUID);
        }
        Pixelmon.EVENT_BUS.post((Event)new BagItemEvent.SelectItem.Post(bc, "", player, this.usedStack, usedStack));
    }
}

