/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class BackToMainMenuPacket
extends AbstractPixelmonPacket {
    private List<Boolean> canSwitch;
    private boolean canFlee;
    private List<UUID> pokemonToChoose;

    public BackToMainMenuPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public BackToMainMenuPacket(List<Boolean> canSwitch, boolean canFlee, List<UUID> pokemonToChoose) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.canSwitch = canSwitch;
        this.canFlee = canFlee;
        this.pokemonToChoose = pokemonToChoose;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.canFlee = buffer.readBoolean();
        int size = buffer.readShort();
        this.pokemonToChoose = Lists.newArrayList();
        this.canSwitch = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.pokemonToChoose.add(new UUID(buffer.readLong(), buffer.readLong()));
            this.canSwitch.add(buffer.readBoolean());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.canFlee);
        buffer.writeShort(this.pokemonToChoose.size());
        for (int i = 0; i < this.pokemonToChoose.size(); ++i) {
            buffer.m_130077_(this.pokemonToChoose.get(i));
            buffer.writeBoolean(this.canSwitch.get(i).booleanValue());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.battleManager.startPicking(this.canSwitch, this.canFlee, (ArrayList)this.pokemonToChoose);
    }
}

