/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AcceptDeclineBattlePacket
extends AbstractPixelmonPacket {
    private EnumBattleQueryResponse response;
    private int queryID;

    public AcceptDeclineBattlePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AcceptDeclineBattlePacket(int queryID, EnumBattleQueryResponse response) {
        super(PacketDirection.PLAY_SERVER, true);
        this.queryID = queryID;
        this.response = response;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.queryID = buffer.readInt();
        this.response = EnumBattleQueryResponse.getFromOrdinal(buffer.readInt());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.queryID);
        buffer.writeInt(this.response.ordinal());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        BattleQuery query = BattleQuery.getQuery(this.queryID);
        if (query == null) {
            return;
        }
        ServerPlayer player = context.getSender();
        player.m_9243_();
        switch (this.response) {
            case Decline: {
                query.declineQuery(player);
                break;
            }
            case Accept: 
            case Rules: {
                query.acceptQuery(player, this.response);
                break;
            }
            case Change: {
                query.changeRules(player);
                break;
            }
        }
    }
}

