/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.screens.BadgeCaseEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.BadgeCaseItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class BadgeCaseActionPacket
extends AbstractPixelmonPacket {
    private Action action;
    private int index1;
    private int index2;
    private boolean custom;

    public BadgeCaseActionPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public BadgeCaseActionPacket(Action action, boolean custom) {
        super(PacketDirection.PLAY_SERVER, true);
        this.action = action;
        this.custom = custom;
    }

    public BadgeCaseActionPacket(int index1, boolean custom) {
        super(PacketDirection.PLAY_SERVER, true);
        this.action = Action.REMOVE;
        this.index1 = index1;
        this.custom = custom;
    }

    public BadgeCaseActionPacket(int index1, int index2, boolean custom) {
        super(PacketDirection.PLAY_SERVER, true);
        this.action = Action.SWAP;
        this.index1 = index1;
        this.index2 = index2;
        this.custom = custom;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.action = Action.values()[buf.readByte()];
        if (this.action == Action.REMOVE || this.action == Action.SWAP) {
            this.index1 = buf.readInt();
        }
        if (this.action == Action.SWAP) {
            this.index2 = buf.readInt();
        }
        this.custom = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.action.ordinal());
        if (this.action == Action.REMOVE || this.action == Action.SWAP) {
            buf.writeInt(this.index1);
        }
        if (this.action == Action.SWAP) {
            buf.writeInt(this.index2);
        }
        buf.writeBoolean(this.custom);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        boolean isVaild;
        ServerPlayer player = context.getSender();
        ItemStack hand = player.m_21205_();
        boolean bl = isVaild = !this.custom && hand.m_41720_() instanceof BadgeCaseItem;
        if (this.action == Action.REGISTER) {
            if (!Pixelmon.EVENT_BUS.post((Event)new BadgeCaseEvent.Register(player, this.custom)) && isVaild) {
                BadgeCaseItem.registerBadgeCase(hand, (Player)player);
            }
        } else if (this.action == Action.REMOVE) {
            if (!Pixelmon.EVENT_BUS.post((Event)new BadgeCaseEvent.Remove(player, this.custom, this.index1)) && isVaild) {
                ItemStack stack = BadgeCaseItem.removeBadge(hand, (Player)player, this.index1);
                DropItemHelper.giveItemStack(player, stack, false);
            }
        } else if (this.action == Action.SWAP && !Pixelmon.EVENT_BUS.post((Event)new BadgeCaseEvent.Swap(player, this.custom, this.index1, this.index2)) && isVaild) {
            BadgeCaseItem.swampBadge(hand, (Player)player, this.index1, this.index2);
        }
        if (isVaild) {
            BadgeCaseItem.openBadgeCase(hand, player);
        }
    }

    public static enum Action {
        REGISTER,
        SWAP,
        REMOVE;

    }
}

