/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.ReviveItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseRevivePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;

    public UseRevivePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseRevivePacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.pokemonUUID);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        ItemStack itemStack = player.m_21205_();
        Item item = itemStack.m_41720_();
        if (!(item instanceof ReviveItem)) {
            return;
        }
        ReviveItem revive = (ReviveItem)item;
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon != null && revive.useMedicine(new DelegateLink(pokemon), 0) && !player.m_7500_()) {
            itemStack.m_41774_(1);
        }
    }
}

