/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdatePixelmonMovementPacket
extends AbstractPixelmonPacket {
    private int id;
    private int takeOffTicks;
    private float lastSpeed;
    private float speed;
    private float rotationPitch;
    private float rotationYaw;
    private float strafe;
    private float strafeUp;
    private double posX;
    private double posY;
    private double posZ;
    private Vec3 targetPosition;
    private boolean hasTargetPos = false;

    public UpdatePixelmonMovementPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public UpdatePixelmonMovementPacket(AbstractMovesEntity pixelmon) {
        super(PacketDirection.PLAY_CLIENT);
        this.id = pixelmon.m_19879_();
        this.speed = pixelmon.getMoveMultiplier();
        this.strafe = pixelmon.f_20900_;
        this.strafeUp = pixelmon.getStrafeUpDown();
        this.targetPosition = pixelmon.getTargetPosition();
        this.hasTargetPos = this.targetPosition != null;
        this.takeOffTicks = pixelmon.takeOffTicks;
        this.posX = pixelmon.m_20185_();
        this.posY = pixelmon.m_20186_();
        this.posZ = pixelmon.m_20189_();
        this.rotationPitch = pixelmon.f_19858_;
        this.rotationYaw = pixelmon.f_19857_;
        this.lastSpeed = pixelmon.lastSpeed;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.speed = buffer.readFloat();
        this.strafe = buffer.readFloat();
        this.strafeUp = buffer.readFloat();
        this.takeOffTicks = buffer.readInt();
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
        this.rotationPitch = buffer.readFloat();
        this.rotationYaw = buffer.readFloat();
        this.lastSpeed = buffer.readFloat();
        if (buffer.readBoolean()) {
            this.hasTargetPos = true;
            this.targetPosition = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.strafe);
        buffer.writeFloat(this.strafeUp);
        buffer.writeInt(this.takeOffTicks);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.writeFloat(this.rotationPitch);
        buffer.writeFloat(this.rotationYaw);
        buffer.writeFloat(this.lastSpeed);
        buffer.writeBoolean(this.hasTargetPos);
        if (this.hasTargetPos) {
            buffer.writeDouble(this.targetPosition.f_82479_);
            buffer.writeDouble(this.targetPosition.f_82480_);
            buffer.writeDouble(this.targetPosition.f_82481_);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.id);
        if (!(entity instanceof AbstractMovesEntity)) {
            return;
        }
        AbstractMovesEntity pixelmon = (AbstractMovesEntity)entity;
        if (pixelmon.m_20160_() && pixelmon.m_6688_() == Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (this.hasTargetPos) {
            pixelmon.setMovementTarget(this.targetPosition);
        }
        pixelmon.setMoveMultiplier(this.speed);
        pixelmon.f_20900_ = this.strafe;
        pixelmon.setStrafeUpDown(this.strafeUp);
        pixelmon.takeOffTicks = this.takeOffTicks;
        pixelmon.f_19858_ = this.rotationPitch;
        if (Math.abs(pixelmon.m_20185_() - this.posX) > 1.0 || Math.abs(pixelmon.m_20186_() - this.posY) > 1.0 || Math.abs(pixelmon.m_20189_() - this.posZ) > 1.0) {
            pixelmon.m_6034_(this.posX, this.posY, this.posZ);
        }
        pixelmon.f_19858_ = this.rotationPitch;
        pixelmon.f_19857_ = this.rotationYaw;
        pixelmon.lastSpeed = this.lastSpeed;
        if (!pixelmon.lastFlyingState) {
            pixelmon.takeOff();
            pixelmon.lastFlyingState = true;
        }
    }
}

