/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UIKeyPressPacket
extends AbstractPixelmonPacket {
    private int keyCode;
    private int scanCode;
    private int modifiers;

    public UIKeyPressPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public UIKeyPressPacket(int keyCode, int scanCode, int modifiers) {
        this();
        this.keyCode = keyCode;
        this.scanCode = scanCode;
        this.modifiers = modifiers;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.keyCode = buf.readInt();
        this.scanCode = buf.readInt();
        this.modifiers = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.keyCode);
        buf.writeInt(this.scanCode);
        buf.writeInt(this.modifiers);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            if (context.getSender() != null) {
                PlayerPartyStorage pps = StorageProxy.getPartyNow(context.getSender());
                pps.receiveKeyInput(this.keyCode, this.scanCode, this.modifiers);
            }
        });
    }
}

