/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TransformPacket
extends AbstractPixelmonPacket {
    public int pixelmonID;
    public Species transformedModel;
    public String transformedTexture;
    public String transformedForm;
    public String transformedParticles;

    public TransformPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public TransformPacket(int is, Species newPokemon, String newTexture, String newForm, String newParticles) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.transformedModel = newPokemon;
        this.transformedTexture = newTexture;
        this.transformedForm = newForm.contains("gmax") ? newPokemon.getForm(newForm).getDefaultBaseForm() : newForm;
        this.transformedParticles = newParticles;
        this.pixelmonID = is;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pixelmonID = buffer.readInt();
        this.transformedModel = PixelmonSpecies.fromNationalDex(buffer.readInt());
        this.transformedTexture = buffer.m_130277_();
        this.transformedForm = buffer.m_130277_();
        this.transformedParticles = buffer.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pixelmonID);
        buffer.writeInt(this.transformedModel.getDex());
        buffer.m_130070_(this.transformedTexture);
        buffer.m_130070_(this.transformedForm);
        buffer.m_130070_(this.transformedParticles);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Transformed.applyToClientEntity(this);
    }
}

