/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SwapMovePacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemonUUID;
    private int selected;
    private int clicked;

    public SwapMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SwapMovePacket(StoragePosition position, UUID pokemonUUID, int selected, int clicked) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemonUUID = pokemonUUID;
        this.selected = selected;
        this.clicked = clicked;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.position = StoragePosition.decode((ByteBuf)buffer);
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.selected = buffer.readByte();
        this.clicked = buffer.readByte();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        this.position.encode((ByteBuf)buffer);
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeByte(this.selected);
        buffer.writeByte(this.clicked);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (this.selected <= -1 || this.selected >= 4) {
            return;
        }
        if (this.clicked <= -1 || this.clicked >= 4) {
            return;
        }
        PokemonStorage storage = this.position.box == -1 ? StorageProxy.getPartyNow(player) : StorageProxy.getPCForPlayerNow(player);
        Pokemon pokemon = storage.get(this.position);
        if (pokemon == null || !pokemon.getUUID().equals(this.pokemonUUID)) {
            return;
        }
        pokemon.getMoveset().swap(this.selected, this.clicked);
    }
}

