/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.particle.Particles;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SummonParticleArcaneryPacket
extends AbstractPixelmonPacket {
    private double posX;
    private double posY;
    private double posZ;
    private double motionX;
    private double motionY;
    private double motionZ;
    private float size;
    private Particles particle;
    private Object[] args;
    private ParticleEffect effect;

    public SummonParticleArcaneryPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SummonParticleArcaneryPacket(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, float size, Particles particle, Object ... args) {
        super(PacketDirection.PLAY_CLIENT);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        this.size = size;
        this.particle = particle;
        this.args = args;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
        this.size = buf.readFloat();
        this.effect = Particles.read((ByteBuf)buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
        buf.writeFloat(this.size);
        Particles.write(buf, this.particle, this.args);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.effect != null) {
            mc.m_6937_(() -> mc.f_91061_.m_107344_((Particle)new ParticleArcanery(this.posX, this.posY, this.posZ, this.motionX, this.motionY, this.motionZ, this.effect)));
        }
    }
}

