/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetMegaItemPacket
extends AbstractPixelmonPacket {
    private EnumMegaItem megaItem;

    public SetMegaItemPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public SetMegaItemPacket(EnumMegaItem megaItem) {
        super(PacketDirection.PLAY_SERVER);
        this.megaItem = megaItem;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.megaItem = EnumMegaItem.values()[buffer.readInt()];
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.megaItem.ordinal());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        if (storage.canEquipMegaItem() && (this.megaItem.canEvolve() && storage.getMegaItemsUnlocked().canMega() || this.megaItem.canDynamax() && storage.getMegaItemsUnlocked().canDynamax() || this.megaItem == EnumMegaItem.None)) {
            storage.setMegaItem(this.megaItem, false);
        }
    }
}

