/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetHeldItemPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemon;
    private Item item;

    public SetHeldItemPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SetHeldItemPacket(StoragePosition position, UUID pokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemon = pokemon;
    }

    public void setItem(Item item) {
        this.item = item == null ? Items.f_41852_ : item;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.position.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon != null);
        if (this.pokemon != null) {
            buf.writeLong(this.pokemon.getMostSignificantBits());
            buf.writeLong(this.pokemon.getLeastSignificantBits());
        }
        buf.writeBoolean(this.item != null);
        if (this.item != null) {
            buf.writeInt(Item.m_41393_((Item)this.item));
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.position = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon = buf.m_130259_();
        }
        this.item = buf.readBoolean() ? Item.m_41445_((int)buf.readInt()) : null;
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PokemonStorage storage = StorageProxy.getStorageNow(player, this.position);
        if (!storage.validate(this.position, this.pokemon)) {
            storage.notifyListener(player, this.position, storage.get(this.position), new EnumUpdateType[0]);
            return;
        }
        if (BattleRegistry.getBattle((Player)player) != null) {
            return;
        }
        InventoryMenu inventory = player.f_36095_;
        Pokemon pokemon = storage.get(this.position);
        Preconditions.checkArgument((pokemon != null ? 1 : 0) != 0, (Object)"The pok\u00e9mon cannot be null since we've already validated it");
        ItemStack newHeldItem = ItemStack.f_41583_;
        ItemStack currentItem = inventory.m_142621_().m_41777_();
        ItemStack giveItem = null;
        if (player.m_7500_()) {
            newHeldItem = this.item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.item, 1);
        } else {
            ItemStack oldItem = pokemon.getHeldItem();
            if (oldItem.m_41619_()) {
                if (!currentItem.m_41619_()) {
                    ItemStack singleItem = currentItem.m_41777_();
                    singleItem.m_41764_(1);
                    newHeldItem = singleItem;
                    currentItem.m_41774_(1);
                }
            } else if (currentItem.m_41619_()) {
                currentItem = oldItem;
                newHeldItem = ItemStack.f_41583_;
            } else if (ItemStack.m_150942_((ItemStack)oldItem, (ItemStack)currentItem)) {
                currentItem.m_41769_(1);
            } else {
                ItemStack singleItem = currentItem.m_41777_();
                singleItem.m_41764_(1);
                newHeldItem = singleItem;
                if (currentItem.m_41613_() <= 1) {
                    currentItem = oldItem;
                } else {
                    currentItem.m_41774_(1);
                    giveItem = oldItem;
                }
            }
        }
        if (newHeldItem.m_41619_()) {
            newHeldItem = ItemStack.f_41583_;
        }
        inventory.m_142503_(currentItem);
        if (giveItem != null && !player.m_150109_().m_36054_(giveItem)) {
            player.m_36176_(giveItem, false);
        }
        pokemon.setHeldItem(newHeldItem);
    }
}

