/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ClientSetPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetDisplayRibbonPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemonUUID;
    private Ribbon ribbon;

    public SetDisplayRibbonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SetDisplayRibbonPacket(StoragePosition position, UUID pokemonUUID, Ribbon ribbon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemonUUID = pokemonUUID;
        this.ribbon = ribbon;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.position = new StoragePosition(buffer.readShort(), buffer.readByte());
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.ribbon = (Ribbon)PixelmonDataSerializers.RIBBON_TYPE.m_6709_(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.position.box);
        buffer.writeByte(this.position.order);
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        PixelmonDataSerializers.RIBBON_TYPE.m_6856_(buffer, (Object)this.ribbon);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PokemonStorage storage = this.position.box == -1 ? StorageProxy.getPartyNow(player) : StorageProxy.getPCForPlayerNow(player);
        Pokemon pokemon = storage.get(this.position);
        if (pokemon == null || !pokemon.getUUID().equals(this.pokemonUUID)) {
            return;
        }
        pokemon.setDisplayedRibbon(this.ribbon);
        NetworkHelper.sendPacket(new ClientSetPacket(storage, this.position, pokemon, EnumUpdateType.Ribbons), player);
    }
}

