/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.enums.ServerCosmetics;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ServerCosmeticsUpdatePacket
extends AbstractPixelmonPacket {
    private Set<ServerCosmetics> serverCosmetics = EnumSet.noneOf(ServerCosmetics.class);

    public ServerCosmeticsUpdatePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public ServerCosmeticsUpdatePacket(Set<ServerCosmetics> serverCosmetics) {
        super(PacketDirection.PLAY_CLIENT);
        this.serverCosmetics = serverCosmetics;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        byte[] bytes = new byte[buf.readByte()];
        buf.readBytes(bytes);
        BitSet set = BitSet.valueOf(bytes);
        for (ServerCosmetics cosmetics : ServerCosmetics.values()) {
            if (!set.get(cosmetics.ordinal())) continue;
            this.serverCosmetics.add(cosmetics);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        BitSet set = new BitSet();
        for (ServerCosmetics cosmetics : this.serverCosmetics) {
            set.set(cosmetics.ordinal());
        }
        byte[] bytes = set.toByteArray();
        buf.writeByte(bytes.length).writeBytes(bytes);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        UUID uuid = Minecraft.m_91087_().m_91094_().m_240411_();
        PixelExtrasData data = new PixelExtrasData(uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        PlayerExtraDataStore.add(data);
    }
}

