/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.config.GeneralConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ServerConfigListPacket
extends AbstractPixelmonPacket {
    public boolean allowCapturingOutsideBattle = PixelmonConfigProxy.getGeneral().isAllowCaptureOutsideBattle();
    public int maxLevel;
    public float ridingSpeedMultiplier;
    public boolean afkHandlerOn;
    public int afkTimerActivateSeconds;
    public boolean renderWildLevels = PixelmonConfigProxy.getGraphics().isRenderWildLevels();
    public boolean allowShinyCharmFromPokedex;
    public boolean allowExternalMoves;
    public boolean limitShopKeeperStackSize;
    public boolean universalTMs;
    public boolean superUniversalTMs;
    public GeneralConfig.ServerDiscord serverDiscord;

    public ServerConfigListPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
        this.maxLevel = PixelmonConfigProxy.getGeneral().getMaxLevel();
        this.ridingSpeedMultiplier = PixelmonConfigProxy.getGeneral().getRiding().getRidingSpeedMultiplier();
        this.afkHandlerOn = PixelmonConfigProxy.getGeneral().getAfkHandler().isEnabled();
        this.afkTimerActivateSeconds = PixelmonConfigProxy.getGeneral().getAfkHandler().getAfkActivateSeconds();
        this.allowShinyCharmFromPokedex = PixelmonConfigProxy.getGeneral().isAllowShinyCharmFromPokedex();
        this.allowExternalMoves = PixelmonConfigProxy.getExternalMoves().isAllowExternalMoves();
        this.limitShopKeeperStackSize = PixelmonConfigProxy.getGeneral().isLimitShopKeeperStackSize();
        this.universalTMs = PixelmonConfigProxy.getGeneral().getTMs().isUniversalTMs();
        this.superUniversalTMs = PixelmonConfigProxy.getGeneral().getTMs().isSuperUniversalTMs();
        this.serverDiscord = PixelmonConfigProxy.getGeneral().getServerDiscord();
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.allowCapturingOutsideBattle = buf.readBoolean();
        this.renderWildLevels = buf.readBoolean();
        this.maxLevel = buf.readInt();
        this.ridingSpeedMultiplier = buf.readFloat();
        this.afkHandlerOn = buf.readBoolean();
        this.afkTimerActivateSeconds = buf.readInt();
        this.allowShinyCharmFromPokedex = buf.readBoolean();
        this.allowExternalMoves = buf.readBoolean();
        this.limitShopKeeperStackSize = buf.readBoolean();
        this.universalTMs = buf.readBoolean();
        this.superUniversalTMs = buf.readBoolean();
        this.serverDiscord = new GeneralConfig.ServerDiscord(buf.m_130277_(), buf.m_130277_());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.allowCapturingOutsideBattle);
        buf.writeBoolean(this.renderWildLevels);
        buf.writeInt(this.maxLevel);
        buf.writeFloat(this.ridingSpeedMultiplier);
        buf.writeBoolean(this.afkHandlerOn);
        buf.writeInt(this.afkTimerActivateSeconds);
        buf.writeBoolean(this.allowShinyCharmFromPokedex);
        buf.writeBoolean(this.allowExternalMoves);
        buf.writeBoolean(this.limitShopKeeperStackSize);
        buf.writeBoolean(this.universalTMs);
        buf.writeBoolean(this.superUniversalTMs);
        buf.m_130070_(this.serverDiscord.getDiscordInvite());
        buf.m_130070_(this.serverDiscord.getServerName());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PixelmonServerConfig.updateFromServer(this);
        PixelmonOverlayScreen.hideSpectateMessage(null);
    }
}

