/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.BottlecapItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SelectStatPacket
extends AbstractPixelmonPacket {
    private int entityId;
    private BattleStatsType type;

    public SelectStatPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SelectStatPacket(int entityId, BattleStatsType type) {
        super(PacketDirection.PLAY_SERVER, true);
        this.entityId = entityId;
        this.type = type;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.type = BattleStatsType.getEVIVStatValues()[buf.readByte()];
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.type.ordinal() - 1);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PixelmonEntity pixelmon;
        ServerPlayer player = context.getSender();
        Entity entity = player.m_9236_().m_6815_(this.entityId);
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (entity instanceof PixelmonEntity && hand.m_41720_() == PixelmonItems.silver_bottle_cap && (pixelmon = (PixelmonEntity)entity).getPokemon().getOwnerPlayer() == player && BottlecapItem.onSilverSelection(player, pixelmon.getPokemon(), this.type) && !player.m_7500_()) {
            hand.m_41774_(1);
        }
    }
}

