/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumMovementType;
import com.pixelmonmod.pixelmon.entities.bikes.BikeEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.enums.EnumMovement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RidingVerticalMovementPacket
extends AbstractPixelmonPacket {
    private EnumMovementType type;
    private EnumMovement[] movement;

    public RidingVerticalMovementPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RidingVerticalMovementPacket(EnumMovement[] movement, EnumMovementType type) {
        super(PacketDirection.PLAY_SERVER, true);
        this.movement = movement;
        this.type = type;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.type = EnumMovementType.getFromOrdinal(buffer.readByte());
        int numMovements = buffer.readShort();
        this.movement = new EnumMovement[numMovements];
        for (int i = 0; i < numMovements; ++i) {
            this.movement[i] = EnumMovement.getMovement(buffer.readShort());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeShort(this.movement.length);
        for (EnumMovement aMovement : this.movement) {
            buffer.writeShort(aMovement.ordinal());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.type == EnumMovementType.Riding) {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_20202_() == null) {
                return;
            }
            if (player.m_20202_() instanceof AbstractInteractionsEntity) {
                AbstractInteractionsEntity mount = (AbstractInteractionsEntity)player.m_20202_();
                if (mount.getPokemon().getForm().getMovement().getMountedFlyingParameters() == null) {
                    return;
                }
                mount.getPokemon().getForm().getMovement().getMountedFlyingParameters().handleKeybindMovement(Lists.newArrayList((Object[])this.movement), (AbstractMovesEntity)mount);
            } else if (player.m_20202_() instanceof BikeEntity && player.m_20202_().m_20096_()) {
                for (EnumMovement movementType : this.movement) {
                    if (movementType != EnumMovement.Jump) continue;
                    ((BikeEntity)player.m_20202_()).jumping = true;
                }
            }
        }
    }
}

