/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RidingMovementPacket
extends AbstractPixelmonPacket {
    private List<EnumKeybinds> movementList;

    public RidingMovementPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RidingMovementPacket(List<EnumKeybinds> movements) {
        super(PacketDirection.PLAY_SERVER, true);
        this.movementList = movements;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int numMovements = buffer.readShort();
        this.movementList = new ArrayList<EnumKeybinds>();
        for (int i = 0; i < numMovements; ++i) {
            this.movementList.add(EnumKeybinds.getMovement(buffer.readShort()));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.movementList.size());
        for (EnumKeybinds aMovement : this.movementList) {
            buffer.writeShort(aMovement.ordinal());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player.m_20202_() instanceof AbstractMovesEntity) {
            ((AbstractMovesEntity)player.m_20202_()).handleMovement(this.movementList);
        }
    }
}

