/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.TeachMoveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.listener.RotomListener;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ReplaceMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String attackId;
    private int replaceIndex;
    private boolean checkEvo;

    public ReplaceMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ReplaceMovePacket(UUID pokemonUUID, String attackId, int replaceIndex, boolean checkEvo) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.replaceIndex = replaceIndex;
        this.checkEvo = checkEvo;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.attackId = buffer.m_130277_();
        this.replaceIndex = buffer.readInt();
        this.checkEvo = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.m_130070_(this.attackId);
        buffer.writeInt(this.replaceIndex);
        buffer.writeBoolean(this.checkEvo);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PlayerParticipant participant;
        ServerPlayer player = context.getSender();
        BattleController bc = BattleRegistry.getBattle((Player)player);
        PokemonLink pokemonLink = null;
        PixelmonWrapper pw = null;
        if (bc != null && (participant = bc.getPlayer((Player)player)) != null && (pw = participant.getPokemonFromParty(this.pokemonUUID)) != null) {
            pokemonLink = new WrapperLink(pw);
        }
        if (pokemonLink == null) {
            pokemonLink = new DelegateLink(StorageProxy.getPartyNow(player).find(this.pokemonUUID));
        }
        if (pokemonLink.getPokemon() == null) {
            return;
        }
        Attack attack = new Attack(this.attackId);
        boolean learnMove = true;
        if (attack.getMove() == null) {
            learnMove = false;
        }
        if (learnMove) {
            if (this.replaceIndex == -1) {
                learnMove = false;
            }
            if (learnMove) {
                boolean messageSent = LearnMoveController.hasCondition(player, this.pokemonUUID, attack.getActualMove());
                if (!LearnMoveController.canLearnMove(player, this.pokemonUUID, attack.getActualMove())) {
                    if (!messageSent) {
                        ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
                    }
                    learnMove = false;
                }
                if (learnMove && this.replaceIndex > -1) {
                    Moveset moveset = pokemonLink.getMoveset();
                    MutableComponent oldMoveName = moveset.get(this.replaceIndex).getMove().getTranslatedName();
                    moveset.set(this.replaceIndex, attack);
                    MutableComponent chatMessage = ChatHandler.getMessage("replacemove.replace", pokemonLink.getRealNickname(), oldMoveName, attack.getMove().getTranslatedName());
                    if (bc == null || bc.battleEnded) {
                        ChatHandler.sendChat((CommandSource)player, (Component)chatMessage);
                    } else {
                        bc.sendToPlayer((Player)player, (Component)chatMessage);
                    }
                    if (pw != null && bc.battleEnded) {
                        pw.writeToNBT();
                    }
                    pokemonLink.update(EnumUpdateType.Moveset);
                    if (pokemonLink.getSpecies().is(PixelmonSpecies.ROTOM)) {
                        RotomListener.replacedMove(pokemonLink, attack);
                    }
                    Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.MoveLearnt.Post((Player)player, pokemonLink.getPokemon(), null, attack.getMove()));
                }
            }
        }
        if (this.checkEvo) {
            if (pw != null) {
                pw.bc.checkedPokemon.add(pw.pokemon);
            } else {
                pokemonLink.getPokemon().tryEvolution();
            }
        }
    }
}

