/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.SetNicknameEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ClientSetPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RenamePokemonPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemonUUID;
    private String name;

    public RenamePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RenamePokemonPacket(StoragePosition position, UUID pokemonUUID, String name) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemonUUID = pokemonUUID;
        this.name = name;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.position = new StoragePosition(buffer.readShort(), buffer.readByte());
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.name = buffer.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.position.box);
        buffer.writeByte(this.position.order);
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.m_130070_(this.name);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        SetNicknameEvent event;
        ServerPlayer player = context.getSender();
        PokemonStorage storage = this.position.box == -1 ? StorageProxy.getPartyNow(player) : StorageProxy.getPCForPlayerNow(player);
        Pokemon pokemon = storage.get(this.position);
        if (pokemon == null || !pokemon.getUUID().equals(this.pokemonUUID)) {
            return;
        }
        this.name = this.name.replaceAll("\u00a7", "&");
        if (TextHelper.DENY_PATTERN.matcher(this.name).replaceAll("").length() > 16) {
            this.name = this.name.substring(0, 16);
        }
        if (Pixelmon.EVENT_BUS.post((Event)(event = new SetNicknameEvent(player, pokemon, this.name)))) {
            this.reply(context, new ClientSetPacket(storage, this.position, pokemon, EnumUpdateType.Nickname));
        } else {
            pokemon.setNickname(event.nickname);
        }
    }
}

