/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class QueryResourceLocationResult
extends AbstractPixelmonPacket {
    private UUID query;
    private boolean found;

    public QueryResourceLocationResult() {
        super(PacketDirection.PLAY_SERVER);
    }

    public QueryResourceLocationResult(UUID query, boolean found) {
        this();
        this.query = query;
        this.found = found;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.query = buf.m_130259_();
        this.found = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.query);
        buf.writeBoolean(this.found);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            if (context.getSender() != null) {
                PlayerPartyStorage pps = StorageProxy.getPartyNow(context.getSender());
                pps.receiveResourceLocationQueryResult(this.query, this.found);
            }
        });
    }
}

