/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.QueryResourceLocationResult;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class QueryResourceLocationPacket
extends AbstractPixelmonPacket {
    UUID query;
    ResourceLocation resource;

    public QueryResourceLocationPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public QueryResourceLocationPacket(UUID query, ResourceLocation resource) {
        this();
        this.query = query;
        this.resource = resource;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.query = buf.m_130259_();
        this.resource = ResourceLocationHelper.of(buf.m_130277_());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.query);
        buf.m_130070_(this.resource.toString());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        NetworkHelper.sendToServer(new QueryResourceLocationResult(this.query, CommonProxy.resourceLocationExists(this.resource)));
    }
}

