/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public abstract class PokemonListPacket
extends AbstractPixelmonPacket {
    public PokemonBase[] pokemonList;

    public PokemonListPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public PokemonListPacket(Species ... pokemon) {
        this(pokemon, new String[pokemon.length]);
    }

    public PokemonListPacket(Species[] pokemon, String[] forms) {
        super(PacketDirection.PLAY_CLIENT, true);
        PokemonBase[] pokemonForms = new PokemonBase[pokemon.length];
        for (int i = 0; i < pokemon.length; ++i) {
            pokemonForms[i] = new PokemonBase(pokemon[i], pokemon[i].getForm(forms[i]));
        }
        this.initialize(pokemonForms);
    }

    public PokemonListPacket(PokemonBase[] pokemon) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.initialize(pokemon);
    }

    private void initialize(PokemonBase[] pokemon) {
        ArrayList base = Lists.newArrayList();
        for (PokemonBase pokemonBase : pokemon) {
            if (!PixelmonConfigProxy.getSpawning().isGenerationEnabled(pokemonBase.getSpecies().getGeneration())) continue;
            base.add(pokemonBase);
        }
        this.pokemonList = base.toArray(new PokemonBase[0]);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonList = new PokemonBase[buffer.readShort()];
        for (int i = 0; i < this.pokemonList.length; ++i) {
            this.pokemonList[i] = (PokemonBase)PixelmonDataSerializers.POKEMON_BASE.m_6709_(buffer);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.pokemonList.length);
        for (PokemonBase pokemonBase : this.pokemonList) {
            PixelmonDataSerializers.POKEMON_BASE.m_6856_(buffer, (Object)pokemonBase);
        }
    }
}

