/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PlayParticleSystemPacket
extends AbstractPixelmonPacket {
    private ParticleSystems system;
    private double x;
    private double y;
    private double z;
    private ResourceLocation dimensionLocation;
    private float scale;
    private boolean shiny;
    private double[] args;

    public PlayParticleSystemPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public PlayParticleSystemPacket(ParticleSystems system, double x, double y, double z, Level world, float scale, boolean shiny, double ... args) {
        super(PacketDirection.PLAY_CLIENT);
        this.system = system;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimensionLocation = world.m_46472_().m_135782_();
        this.scale = scale;
        this.shiny = shiny;
        this.args = args;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.system = ParticleSystems.values()[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.dimensionLocation = buf.m_130281_();
        this.scale = buf.readFloat();
        this.shiny = buf.readBoolean();
        this.args = new double[buf.readInt()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = buf.readDouble();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.system.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.m_130085_(this.dimensionLocation);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.shiny);
        buf.writeInt(this.args.length);
        for (double arg : this.args) {
            buf.writeDouble(arg);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)this.dimensionLocation)) {
            this.system.getSystem().execute(Minecraft.m_91087_(), (Level)Minecraft.m_91087_().f_91073_, this.x, this.y, this.z, this.scale, this.shiny, this.args);
        }
    }
}

