/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PlayBattleParticleSystemPacket
extends AbstractPixelmonPacket {
    private AttackAnimationData effect;
    private ImmutableAttack immutableAttack;
    private ResourceLocation dimension;
    private int power;
    private byte effectiveType;
    private int accuracy;
    private float startX;
    private float startY;
    private float startZ;
    private float endX;
    private float endY;
    private float endZ;
    private int startID;
    private int endID;

    public PlayBattleParticleSystemPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public PlayBattleParticleSystemPacket(AttackAnimation animation, Attack attack, AttackAnimationData effect, boolean groundedStartPosition, boolean groundedEndPosition) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = animation.dimension.m_135782_();
        this.startID = animation.startID;
        float f = this.startX = animation.user.entity == null ? animation.userPos[0] : (float)animation.user.entity.m_20185_();
        this.startY = animation.user.entity == null ? animation.userPos[1] : (groundedStartPosition ? (float)animation.user.entity.m_20186_() : (float)animation.user.entity.getYCentre());
        this.startZ = animation.user.entity == null ? animation.userPos[2] : (float)animation.user.entity.m_20189_();
        this.endID = animation.endID;
        float f2 = this.endX = animation.target.entity == null ? animation.targetPos[0] : (float)animation.target.entity.m_20185_();
        this.endY = animation.target.entity == null ? animation.targetPos[1] : (groundedEndPosition ? (float)animation.target.entity.m_20186_() : (float)animation.target.entity.getYCentre());
        this.endZ = animation.target.entity == null ? animation.targetPos[2] : (float)animation.target.entity.m_20189_();
        this.power = attack.getAttackCategory() == AttackCategory.STATUS ? 50 : attack.movePower;
        this.effectiveType = (byte)animation.effectiveType.ordinal();
        this.accuracy = attack.moveAccuracy;
        this.effect = effect;
        this.immutableAttack = attack.getMove();
    }

    public PlayBattleParticleSystemPacket(Level dimension, AttackAnimationData effect, ImmutableAttack ab, int startID, Vec3 startPos, int endID, Vec3 endPos) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = dimension.m_46472_().m_135782_();
        this.startID = startID;
        this.startX = (float)startPos.f_82479_;
        this.startY = (float)startPos.f_82480_;
        this.startZ = (float)startPos.f_82481_;
        this.endID = endID;
        this.endX = (float)endPos.f_82479_;
        this.endY = (float)endPos.f_82480_;
        this.endZ = (float)endPos.f_82481_;
        this.power = ab.getAttackCategory() == AttackCategory.STATUS ? 50 : ab.getBasePower();
        this.effectiveType = (byte)ab.getAttackType().ordinal();
        this.accuracy = ab.getAccuracy();
        this.effect = effect;
        this.immutableAttack = ab;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.dimension = buf.m_130281_();
        this.power = buf.readShort();
        this.effectiveType = buf.readByte();
        this.accuracy = buf.readShort();
        this.startX = buf.readFloat();
        this.startY = buf.readFloat();
        this.startZ = buf.readFloat();
        this.endX = buf.readFloat();
        this.endY = buf.readFloat();
        this.endZ = buf.readFloat();
        this.startID = buf.readInt();
        this.endID = buf.readInt();
        if (buf.readBoolean()) {
            this.effect = EffectType.values()[buf.readByte()].getDataSupplier().get().readFromByteBuffer((ByteBuf)buf);
        }
        this.immutableAttack = AttackRegistry.getAttackBase(buf.m_130277_()).get();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension);
        buf.writeShort(this.power);
        buf.writeByte((int)this.effectiveType);
        buf.writeShort(this.accuracy);
        buf.writeFloat(this.startX);
        buf.writeFloat(this.startY);
        buf.writeFloat(this.startZ);
        buf.writeFloat(this.endX);
        buf.writeFloat(this.endY);
        buf.writeFloat(this.endZ);
        buf.writeInt(this.startID);
        buf.writeInt(this.endID);
        buf.writeBoolean(this.effect != null && this.effect.getEffectEnum() != null);
        if (this.effect != null && this.effect.getEffectEnum() != null) {
            buf.writeByte(this.effect.getEffectEnum().ordinal());
            this.effect.writeToByteBuffer((ByteBuf)buf);
        }
        buf.m_130070_(this.immutableAttack.getAttackName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.effect == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)this.dimension)) {
            this.effect.initFromAttack(this.immutableAttack, this.power, Element.values()[this.effectiveType]);
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_.m_46472_().m_135782_().equals((Object)this.dimension)) {
                this.effect.createSystem(mc, this.startID, new float[]{this.startX, this.startY, this.startZ}, this.endID, new float[]{this.endX, this.endY, this.endZ});
            }
        }
    }
}

