/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.enums.ServerCosmetics;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PixelExtrasDisplayClientPacket
extends AbstractPixelmonPacket {
    private UUID uuid;
    public int dataHash;
    private final EnumSet<PixelExtrasData.Category> enabled = EnumSet.noneOf(PixelExtrasData.Category.class);
    private Set<ServerCosmetics> serverCosmetics = EnumSet.noneOf(ServerCosmetics.class);
    private PixelExtrasData.HatType hatType = PixelExtrasData.HatType.NONE;
    private PixelExtrasData.MonocleType monocleType = PixelExtrasData.MonocleType.NONE;
    private PixelExtrasData.SashType sashType = PixelExtrasData.SashType.NONE;
    private PixelExtrasData.RobeType robeType = PixelExtrasData.RobeType.NONE;
    private PixelExtrasData.SphealType sphealType = PixelExtrasData.SphealType.DEFAULT;
    private PixelExtrasData.WingType wingType = PixelExtrasData.WingType.NONE;
    private final int[][] colours = new int[3][3];

    public PixelExtrasDisplayClientPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public PixelExtrasDisplayClientPacket(PixelExtrasData data) {
        this();
        this.uuid = data.id;
        this.dataHash = data.dataHash();
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            if (!data.isEnabled(category)) continue;
            this.enabled.add(category);
        }
        this.serverCosmetics = data.getServerCosmetics();
        this.hatType = data.getHatType();
        this.monocleType = data.getMonocleType();
        this.sashType = data.getSashType();
        this.robeType = data.getRobeType();
        this.sphealType = data.getSphealType();
        this.wingType = data.getWingType();
        this.colours[0] = data.getColours(PixelExtrasData.Category.SASH);
        this.colours[1] = data.getColours(PixelExtrasData.Category.HAT);
        this.colours[2] = data.getColours(PixelExtrasData.Category.MONOCLE);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.dataHash = buf.readInt();
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            if (!buf.readBoolean()) continue;
            this.enabled.add(category);
        }
        byte[] bytes = new byte[buf.readByte()];
        buf.readBytes(bytes);
        BitSet set = BitSet.valueOf(bytes);
        for (ServerCosmetics cosmetics : ServerCosmetics.values()) {
            if (!set.get(cosmetics.ordinal())) continue;
            this.serverCosmetics.add(cosmetics);
        }
        this.hatType = PixelExtrasData.HatType.getFromId(buf.readByte());
        this.monocleType = PixelExtrasData.MonocleType.getFromId(buf.readByte());
        this.sashType = PixelExtrasData.SashType.values()[buf.readByte()];
        this.robeType = PixelExtrasData.RobeType.values()[buf.readByte()];
        this.sphealType = PixelExtrasData.SphealType.values()[buf.readByte()];
        this.wingType = PixelExtrasData.WingType.values()[buf.readByte()];
        for (int i = 0; i < this.colours.length; ++i) {
            for (int b = 0; b < 3; ++b) {
                this.colours[i][b] = buf.readInt();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeInt(this.dataHash);
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            buf.writeBoolean(this.enabled.contains((Object)category));
        }
        BitSet set = new BitSet();
        for (ServerCosmetics cosmetics : this.serverCosmetics) {
            set.set(cosmetics.ordinal());
        }
        byte[] bytes = set.toByteArray();
        buf.writeByte(bytes.length).writeBytes(bytes);
        buf.writeByte(this.hatType.id);
        buf.writeByte(this.monocleType.id);
        buf.writeByte(this.sashType.ordinal());
        buf.writeByte(this.robeType.ordinal());
        buf.writeByte(this.sphealType.ordinal());
        buf.writeByte(this.wingType.ordinal());
        for (int i = 0; i < this.colours.length; ++i) {
            for (int b = 0; b < 3; ++b) {
                buf.writeInt(this.colours[i][b]);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PixelExtrasData data = new PixelExtrasData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        ExtrasContact.updateData(data, this.dataHash).whenComplete((pixelExtrasData, throwable) -> {
            this.handleData((PixelExtrasData)pixelExtrasData);
            PlayerExtraDataStore.add(pixelExtrasData);
        });
    }

    private void handleData(PixelExtrasData data) {
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            data.setEnabled(category, this.enabled.contains((Object)category));
        }
        data.setHatType(this.hatType);
        data.setMonocleType(this.monocleType);
        data.setSashType(this.sashType);
        data.setRobeType(this.robeType);
        data.setSphealType(this.sphealType);
        data.setWingType(this.wingType);
        data.setColours(PixelExtrasData.Category.SASH, this.colours[0]);
        data.setColours(PixelExtrasData.Category.HAT, this.colours[1]);
        data.setColours(PixelExtrasData.Category.MONOCLE, this.colours[2]);
    }
}

