/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenScreenPacket
extends AbstractPixelmonPacket {
    private EnumGuiScreen gui;
    private int[] data;

    public OpenScreenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private OpenScreenPacket(EnumGuiScreen gui, int ... data) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.gui = gui;
        this.data = data;
    }

    public static void open(Player player, EnumGuiScreen gui, int ... data) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8924_.execute(() -> NetworkHelper.sendPacket(new OpenScreenPacket(gui, data), (ServerPlayer)player));
        } else {
            OpenScreenPacket.openClient(player, gui, data);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.gui = EnumGuiScreen.getFromOrdinal(buf.readByte());
        this.data = new int[buf.readByte()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.gui.getIndex());
        buf.writeByte(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        OpenScreenPacket.openClient((Player)Minecraft.m_91087_().f_91074_, this.gui, this.data);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClient(Player player, EnumGuiScreen gui, int[] data) {
        Screen screen = ClientProxy.createScreen(player, gui, data);
        Minecraft.m_91087_().m_91152_(screen);
    }
}

