/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenReplaceMoveScreenPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String attackId;
    private boolean checkEvo;

    public OpenReplaceMoveScreenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, ImmutableAttack move) {
        this(pokemonUUID, move.getAttackName(), false);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, ImmutableAttack move, boolean checkEvo) {
        this(pokemonUUID, move.getAttackName(), checkEvo);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, String attackId, boolean checkEvo) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.checkEvo = checkEvo;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pokemonUUID = buf.m_130259_();
        this.attackId = buf.m_130277_();
        this.checkEvo = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.pokemonUUID);
        buf.m_130070_(this.attackId);
        buf.writeBoolean(this.checkEvo);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        AttackData attackData = new AttackData(this.pokemonUUID, new Attack(this.attackId), this.checkEvo);
        if (ClientProxy.battleManager.newAttackList.contains(attackData)) {
            return;
        }
        ClientProxy.battleManager.newAttackList.add(attackData);
        if (!(Minecraft.m_91087_().f_91080_ instanceof BattleScreen) && !(Minecraft.m_91087_().f_91080_ instanceof EvolveScreen)) {
            Minecraft.m_91087_().m_91152_((Screen)new BattleScreen());
        }
    }
}

