/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class LevelUpPacket
extends AbstractPixelmonPacket {
    public UUID pokemonUUID;
    public int level;
    public PixelmonStatsData statsLevel1;
    public PixelmonStatsData statsLevel2;
    public PixelmonClientData poke;

    public LevelUpPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public LevelUpPacket(UUID pokemonUUID, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2, PixelmonClientData poke) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
        this.poke = poke;
    }

    public LevelUpPacket(CompoundTag p, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = p.m_128342_("UUID");
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.level = buffer.readInt();
        this.statsLevel1 = new PixelmonStatsData();
        this.statsLevel1.readPacketData((ByteBuf)buffer);
        this.statsLevel2 = new PixelmonStatsData();
        this.statsLevel2.readPacketData((ByteBuf)buffer);
        this.poke = new PixelmonClientData();
        this.poke.decodeFrom(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.pokemonUUID);
        buffer.writeInt(this.level);
        this.statsLevel1.writePacketData((ByteBuf)buffer);
        this.statsLevel2.writePacketData((ByteBuf)buffer);
        this.poke.encodeInto(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.battleManager.levelUpList.add(this);
        if (!(Minecraft.m_91087_().f_91080_ instanceof BattleScreen)) {
            if (ClientProxy.battleManager.fullOurPokemon == null) {
                ClientProxy.battleManager.fullOurPokemon = Lists.newArrayList();
            }
            ClientProxy.battleManager.fullOurPokemon.add(this.poke);
            Minecraft.m_91087_().m_91152_((Screen)new BattleScreen());
        }
    }
}

