/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class LensInfoPacket
extends AbstractPixelmonPacket {
    private boolean hide = false;
    private int entityID;
    public IVStore ivs;
    public String abilityLangKey;
    public Nature nature;

    public LensInfoPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public LensInfoPacket(PixelmonEntity pixelmon) {
        this(pixelmon, false);
    }

    public LensInfoPacket(PixelmonEntity pixelmon, boolean hide) {
        super(PacketDirection.PLAY_CLIENT);
        this.hide = hide;
        if (!this.hide) {
            this.entityID = pixelmon.m_19879_();
            this.ivs = pixelmon.getPokemon().getIVs();
            this.abilityLangKey = pixelmon.getPokemon().getAbility().getTranslationKey();
            this.nature = pixelmon.getPokemon().getNature();
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.hide = buf.readBoolean();
        if (!this.hide) {
            this.entityID = buf.readInt();
            this.ivs = new IVStore().readFromByteBuffer((ByteBuf)buf);
            this.abilityLangKey = buf.m_130277_();
            this.nature = Nature.values()[buf.readByte()];
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.hide);
        if (!this.hide) {
            buf.writeInt(this.entityID);
            this.ivs.writeToByteBuffer((ByteBuf)buf);
            buf.m_130070_(this.abilityLangKey);
            buf.writeByte(this.nature.ordinal());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
        if (entity instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)entity;
            if (this.hide) {
                pixelmon.setClientOnlyInfo(null);
            } else {
                pixelmon.setClientOnlyInfo(this);
            }
        }
    }
}

