/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.OccupiedPokeBallEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class KeyPacket
extends AbstractPixelmonPacket {
    private static long lastThrownTime = -1L;
    private int selectedPixelmon;
    private int entityID;
    private int moveIndex;
    private int x;
    private int y;
    private int z;
    private int side;
    private EnumKeyPacketMode mode;

    public KeyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public KeyPacket(int selectedPixelmon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.mode = EnumKeyPacketMode.SendPokemon;
    }

    public KeyPacket(int selectedPixelmon, int entityId, EnumKeyPacketMode mode) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.entityID = entityId;
        this.mode = mode;
    }

    public KeyPacket(int selectedPixelmon, int moveIndex, int entityId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = moveIndex;
        this.entityID = entityId;
        this.mode = EnumKeyPacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int selectedPixelmon, String moveName, int entityId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = this.moveIndex;
        this.entityID = entityId;
        this.mode = EnumKeyPacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int selectedPixelmon, int moveIndex, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = moveIndex;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.mode = EnumKeyPacketMode.ExternalMoveBlock;
        this.side = side.m_122411_();
    }

    public KeyPacket(int selectedPixelmon, String moveName, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = this.moveIndex;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.mode = EnumKeyPacketMode.ExternalMoveBlock;
        this.side = side.m_122411_();
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.mode = EnumKeyPacketMode.getFromOrdinal(buffer.readByte());
        this.selectedPixelmon = buffer.readByte();
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                this.entityID = buffer.readInt();
                break;
            }
            case ExternalMoveEntity: {
                this.entityID = buffer.readInt();
                this.moveIndex = buffer.readInt();
                break;
            }
            case ExternalMoveBlock: {
                this.moveIndex = buffer.readInt();
                this.x = buffer.readInt();
                this.y = buffer.readInt();
                this.z = buffer.readInt();
                this.side = buffer.readInt();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeByte(this.mode.ordinal());
        buffer.writeByte(this.selectedPixelmon);
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                buffer.writeInt(this.entityID);
                break;
            }
            case ExternalMoveEntity: {
                buffer.writeInt(this.entityID);
                buffer.writeInt(this.moveIndex);
                break;
            }
            case ExternalMoveBlock: {
                buffer.writeInt(this.moveIndex);
                buffer.writeInt(this.x);
                buffer.writeInt(this.y);
                buffer.writeInt(this.z);
                buffer.writeInt(this.side);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        EnumKeyPacketMode mode = this.mode;
        KeyEvent event = new KeyEvent(context.getSender(), mode);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (mode == EnumKeyPacketMode.SendPokemon) {
            this.sendPokemon(context);
            return;
        }
        Level world = context.getSender().m_9236_();
        ServerPlayer player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (player.m_5833_()) {
            ChatHandler.sendChat((Entity)player, "sendpixelmon.isspectator", new Object[0]);
            return;
        }
        if (pokemon == null || pokemon.getPixelmonEntity() == null) {
            return;
        }
        PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
        if (pixelmon != null) {
            if (mode == EnumKeyPacketMode.ActionKeyEntity) {
                LivingEntity entity = (LivingEntity)world.m_6815_(this.entityID);
                pixelmon.m_6710_(entity);
            }
            if (mode.isAction()) {
                pixelmon.update(EnumUpdateType.Target);
            }
        }
    }

    private void sendPokemon(CustomPayloadEvent.Context context) {
        if (!Pixelmon.canSendOutPokemon) {
            return;
        }
        ServerPlayer player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (pokemon == null || pokemon.isEgg()) {
            return;
        }
        String nickname = pokemon.getDisplayName();
        if (pokemon.isFainted()) {
            ChatHandler.sendChat((Entity)player, "sendpixelmon.cantbattle", Component.m_237115_((String)nickname));
        } else if (pokemon.getPixelmonEntity().isPresent()) {
            PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
            if (pixelmon.m_6688_() == player) {
                player.m_6038_();
            }
            if (pixelmon.m_269323_() == null) {
                pixelmon.unloadEntity();
            } else if (pixelmon.m_269323_() == player) {
                pixelmon.retrieve("PlayerActivated");
                ChatHandler.sendChat((Entity)player, "sendpixelmon.retrieved", Component.m_237115_((String)nickname));
            }
        } else {
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Pre(player, pokemon))) {
                return;
            }
            long worldTime = player.m_9236_().m_46468_();
            if (lastThrownTime - worldTime < 300L && storage.transientData.thrownPokeball != null && storage.transientData.thrownPokeball.m_6084_()) {
                return;
            }
            PokeBall caughtBall = pokemon.getBall();
            storage.transientData.thrownPokeball = new OccupiedPokeBallEntity(player.m_9236_(), (LivingEntity)player, this.selectedPixelmon, caughtBall);
            if (player.m_9236_().m_7967_((Entity)storage.transientData.thrownPokeball)) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (RandomHelper.getRandom().nextFloat() * 0.4f + 0.8f));
                ChatHandler.sendChat((Entity)player, "sendpixelmon.sentout", Component.m_237115_((String)nickname));
                lastThrownTime = worldTime;
            } else {
                storage.transientData.thrownPokeball = null;
            }
        }
    }
}

