/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.config.GeneralConfig;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockReveal;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class IlluminatePositionsPacket
extends AbstractPixelmonPacket {
    private ResourceKey<Level> dimension;
    private int durationTicks;
    private Map<BlockPos, GeneralConfig.OreColor> locationColors = new HashMap<BlockPos, GeneralConfig.OreColor>();

    public IlluminatePositionsPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public IlluminatePositionsPacket(Level world, int durationTicks, HashMap<BlockPos, GeneralConfig.OreColor> locationColors) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = world.m_46472_();
        this.durationTicks = durationTicks;
        this.locationColors = locationColors;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.dimension = DimensionHelper.getDimension(buf.m_130281_());
        this.durationTicks = buf.readUnsignedShort();
        int locationCount = buf.readUnsignedShort();
        for (int i = 0; i < locationCount; ++i) {
            BlockPos pos = buf.m_130135_();
            String blockId = buf.m_130277_();
            int color = buf.readInt();
            int pattern = buf.readInt();
            this.locationColors.put(pos, new GeneralConfig.OreColor(blockId, color, pattern));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.writeShort(this.durationTicks);
        buf.writeShort(this.locationColors.size());
        for (Map.Entry<BlockPos, GeneralConfig.OreColor> entry : this.locationColors.entrySet()) {
            buf.m_130064_(entry.getKey());
            buf.m_130070_(entry.getValue().getBlockId());
            buf.writeInt(entry.getValue().getColor());
            buf.writeInt(entry.getValue().getPattern());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        for (Map.Entry<BlockPos, GeneralConfig.OreColor> entry : this.locationColors.entrySet()) {
            BlockRevealRenderer.revealedBlocks.add(new BlockReveal(this.dimension, this.durationTicks, entry.getKey(), entry.getValue().getColor(), entry.getValue().getPattern()));
        }
    }
}

