/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeleteMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private int removeIndex;

    public DeleteMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public DeleteMovePacket(UUID pokemonUUID, int removeIndex) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.removeIndex = removeIndex;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.removeIndex = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeInt(this.removeIndex);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (this.removeIndex <= -1 || this.removeIndex >= 4) {
            return;
        }
        if (pokemon == null) {
            pokemon = StorageProxy.getPCForPlayerNow(player).find(this.pokemonUUID);
        }
        if (pokemon == null) {
            return;
        }
        if (pokemon.getMoveset().size() <= 1) {
            return;
        }
        Attack removed = pokemon.getMoveset().remove(this.removeIndex);
        if (removed != null) {
            ChatHandler.sendChat((Entity)player, "deletemove.forgot", pokemon.getSpecies().getLocalizedName(), removed.getActualMove().getTranslatedName());
        }
    }
}

