/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.config.starter.StarterList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChooseStarterPacket
extends AbstractPixelmonPacket {
    private int index;
    private boolean[] options;

    public ChooseStarterPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChooseStarterPacket(int index, boolean[] options) {
        super(PacketDirection.PLAY_SERVER, true);
        this.index = index;
        this.options = options;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.index = buf.readInt();
        this.options = new boolean[buf.readInt()];
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i] = buf.readBoolean();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.index);
        buf.writeInt(this.options.length);
        for (boolean option : this.options) {
            buf.writeBoolean(option);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        StarterList.pick(context.getSender(), this.index, this.options);
    }
}

