/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTraderEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AcceptNPCTradePacket
extends AbstractPixelmonPacket {
    private int id = -1;

    public AcceptNPCTradePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AcceptNPCTradePacket(int id) {
        super(PacketDirection.PLAY_SERVER, true);
        this.id = id;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
    }

    @Override
    public void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        TradePair tradePair = NPCTrades.getTradePair(player.m_20148_());
        if (tradePair == null) {
            return;
        }
        Pokemon pokemon = tradePair.offer.create();
        PlayerPartyStorage party = StorageProxy.getPartyNow(context.getSender());
        for (int i = 0; i < party.getAll().length; ++i) {
            NPCEntity npcEntity;
            NPCTraderEvent.AcceptTrade.Pre pre;
            PokedexEvent.Pre preEvent;
            Pokemon partyPokemon = party.get(i);
            if (partyPokemon == null || partyPokemon.isEgg() || !tradePair.exchange.matches(partyPokemon) || partyPokemon.isUntradeable()) continue;
            if (!pokemon.isEgg() && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(player.m_20148_(), pokemon, PokedexRegistrationStatus.CAUGHT, "tradeNPC")))) {
                party.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                party.playerPokedex.update();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
            if (Pixelmon.EVENT_BUS.post((Event)(pre = new NPCTraderEvent.AcceptTrade.Pre((Player)player, npcEntity = (NPCEntity)NPCEntity.locateNPCServer(player.m_9236_(), this.id, NPCEntity.class).orElse(null), tradePair, partyPokemon, pokemon, !PixelmonConfigProxy.getGeneral().isTradersReusable())))) continue;
            if (pre.isRemoveNPC() && npcEntity != null) {
                npcEntity.m_142687_(Entity.RemovalReason.KILLED);
            }
            pokemon = pre.getTradedPokemon();
            player.m_6915_();
            party.set(i, pokemon);
            PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon((Entity)player);
            Pokemon finalPokemon = pokemon;
            pokemon.getEvolutions(TradeEvolution.class).forEach(evo -> {
                if (evo.canEvolve(pixelmon, finalPokemon.getSpecies())) {
                    evo.doEvolution(pixelmon, "Trade");
                }
            });
            Pixelmon.EVENT_BUS.post((Event)new NPCTraderEvent.AcceptTrade.Post((Player)player, npcEntity, tradePair, partyPokemon, pokemon, pre.isRemoveNPC()));
            return;
        }
    }
}

