/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PixelmonSpawnerData {
    int x;
    int y;
    int z;
    CompoundTag nbt;
    List<PokemonRarity> rarities = Lists.newArrayList();

    public PixelmonSpawnerData(BlockPos pos, CompoundTag nbt, List<PokemonRarity> rarities) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.nbt = nbt;
        this.rarities = rarities;
    }

    public PixelmonSpawnerData() {
    }

    public void writePacketData(FriendlyByteBuf data) {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.m_130079_((Tag)this.nbt);
        data.writeInt(this.rarities.size());
        for (PokemonRarity rarity : this.rarities) {
            rarity.writeToBuffer(data);
        }
    }

    public void readPacketData(FriendlyByteBuf data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.nbt = data.m_130260_();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            this.rarities.add(PokemonRarity.readFromBuffer(data));
        }
    }

    public void updateTileEntity(Level world) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (world != null && (blockEntity = world.m_7702_(pos = new BlockPos(this.x, this.y, this.z))) instanceof PixelmonSpawnerTileEntity) {
            PixelmonSpawnerTileEntity t = (PixelmonSpawnerTileEntity)blockEntity;
            t.m_142466_(this.nbt);
            t.pokemonList = this.rarities;
            t.finishEdit();
        }
    }
}

