/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientUpdatePokedexPacket
extends AbstractPixelmonPacket {
    private Map<Integer, PokedexRegistrationStatus> data;
    private Table<Integer, Short, Short> data2;

    public ClientUpdatePokedexPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientUpdatePokedexPacket(PlayerPokedex p) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.data = p.getSeenMap();
        this.data2 = p.formDex;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.data.size());
        for (Map.Entry<Integer, PokedexRegistrationStatus> pair : this.data.entrySet()) {
            buffer.writeInt(pair.getKey().intValue());
            buffer.writeShort(pair.getValue().ordinal());
        }
        buffer.writeInt(this.data2.cellSet().size());
        this.data2.cellSet().forEach(cell -> {
            buffer.writeInt(((Integer)cell.getRowKey()).intValue());
            buffer.writeShort((int)((Short)cell.getColumnKey()).shortValue());
            buffer.writeShort((int)((Short)cell.getValue()).shortValue());
        });
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.data = new HashMap<Integer, PokedexRegistrationStatus>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.data.put(buffer.readInt(), PokedexRegistrationStatus.get(buffer.readShort()));
        }
        this.data2 = HashBasedTable.create();
        int size2 = buffer.readInt();
        for (int i = 0; i < size2; ++i) {
            this.data2.put((Object)buffer.readInt(), (Object)buffer.readShort(), (Object)buffer.readShort());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientStorageManager.pokedex.update(this.data, this.data2);
    }
}

