/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.BattleMessageEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.Event;

public class ChatHandler {
    public static void sendChat(Entity entityLiving, String string, Object ... data) {
        ChatHandler.sendChat((CommandSource)entityLiving, (Component)ChatHandler.getMessage(string, data));
    }

    public static void sendChat(CommandSource receiver, Component message) {
        receiver.m_213846_(message);
    }

    public static void sendChat(CommandSource owner, CommandSource owner2, String string, Object ... data) {
        MutableComponent component = ChatHandler.getMessage(string, data);
        ChatHandler.sendChat(owner, (Component)component);
        ChatHandler.sendChat(owner2, (Component)component);
    }

    public static void sendFormattedChat(CommandSource receiver, ChatFormatting chatFormat, String string, Object ... data) {
        MutableComponent component = Component.m_237110_((String)string, (Object[])data);
        component.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)chatFormat));
        ChatHandler.sendChat(receiver, (Component)component);
    }

    public static void sendBattleMessage(Entity user, String string, Object ... data) {
        MutableComponent component = Component.m_237110_((String)string, (Object[])data);
        component.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY));
        ChatHandler.sendBattleMessage(user, (Component)component);
    }

    public static void sendBattleMessage(Entity user, Component chat) {
        if (user instanceof ServerPlayer) {
            NetworkHelper.sendPacket(new BattleMessagePacket(chat), (ServerPlayer)user);
        }
        Pixelmon.EVENT_BUS.post((Event)new BattleMessageEvent(user, chat));
    }

    public static void sendBattleMessage(List<BattleParticipant> participants, String string, Object ... data) {
        ChatHandler.sendBattleMessage(participants, (Component)ChatHandler.getMessage(string, data));
    }

    public static void sendBattleMessage(List<BattleParticipant> participants, Component message) {
        for (BattleParticipant p : participants) {
            if (p.getEntity() != null) {
                ChatHandler.sendBattleMessage((Entity)p.getEntity(), message);
                continue;
            }
            if (!(p instanceof TestParticipant)) continue;
            ((TestParticipant)p).logBattleMessage(message);
        }
        List<Spectator> spectators = participants.get((int)0).bc.spectators;
        spectators.forEach(spectator -> spectator.sendBattleMessage(message));
    }

    public static MutableComponent getMessage(String string, Object ... data) {
        MutableComponent message = Component.m_237110_((String)string, (Object[])data);
        message.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY));
        return message;
    }

    public static void sendMessageToAllPlayers(MinecraftServer minecraftServer, String string, Object ... data) {
        MutableComponent translation = ChatHandler.getMessage(string, data);
        minecraftServer.m_6846_().m_240416_((Component)translation, false);
    }
}

