/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.richpresence;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.LogLevel;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.Activity;
import de.jcm.discordgamesdk.activity.ActivityButton;
import de.jcm.discordgamesdk.activity.ActivityButtonsMode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.IntegratedServer;
import org.slf4j.event.Level;

public final class PixelmonRichPresence {
    public static final String LOADING_GAME = "Loading Game (%v)";
    public static final String MAIN_MENU = "Main Menu (%v)";
    public static final String SINGLEPLAYER = "Singleplayer (%v)";
    public static final String NOSERVER_DETAIL = "Catching them all!";
    public static final String SERVER_DETAIL = "Playing on %s";
    public static final String LOCAL_MULTIPLAYER = "Local Multiplayer (%v)";
    public static final String MULTIPLAYER = "Multiplayer (%v)";
    private final ThreadPool THREAD_POOL = ThreadPool.createNewThreadPool("Pixelmon Rich Presence", 2);
    private final long application;
    private Instant time;
    private boolean available = false;
    private boolean initing = false;
    private boolean active = false;
    private boolean acknowledgedServer = false;
    private Core core;
    private final boolean enabled = PixelmonConfigProxy.getGeneral().isUseDiscordRichPresence();

    public PixelmonRichPresence(long application) {
        this.application = application;
        this.init();
    }

    public boolean isAcknowledgedServer() {
        return this.acknowledgedServer;
    }

    public void setAcknowledgedServer(boolean acknowledgedServer) {
        this.acknowledgedServer = acknowledgedServer;
    }

    public void init() {
        if (this.enabled) {
            this.initing = true;
            try {
                URL discordLib = this.getDiscordLib();
                if (discordLib == null) {
                    return;
                }
                this.time = Instant.now();
                try (CreateParams createParams = new CreateParams();){
                    createParams.setClientID(this.application);
                    createParams.setFlags(CreateParams.Flags.NO_REQUIRE_DISCORD);
                    this.core = new Core(createParams);
                    this.core.setLogHook(LogLevel.INFO, (logLevel, s) -> Pixelmon.LOGGER.makeLoggingEventBuilder(Level.intToLevel((int)logLevel.ordinal())).log(s));
                    this.setState(LOADING_GAME);
                    this.core.runCallbacks();
                    this.THREAD_POOL.scheduleAtFixedRate(this::poll, 0L, 5000L, TimeUnit.MILLISECONDS);
                    this.initing = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Runtime.getRuntime().addShutdownHook(new Thread(this::destruct));
        }
    }

    private URL getDiscordLib() throws URISyntaxException, IOException {
        String name = "discord_game_sdk";
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        String suffix = this.getOsSuffix(osName);
        if (arch.equals("amd64")) {
            arch = "x86_64";
        }
        String zipPath = "/discord_game_sdk/lib/" + arch + "/" + name + suffix;
        return Pixelmon.class.getResource(zipPath);
    }

    private String getOsSuffix(String osName) throws IllegalArgumentException {
        if (osName.contains("windows")) {
            return ".dll";
        }
        if (osName.contains("linux")) {
            return ".so";
        }
        if (osName.contains("mac os")) {
            return ".dylib";
        }
        throw new IllegalArgumentException("cannot determine OS type: " + osName);
    }

    public void setState(String state) {
        this.setState(state, "", -1, -1, true);
    }

    public void setState(String state, boolean updateTime) {
        this.setState(state, "", -1, -1, updateTime);
    }

    public void setState(String state, String details, boolean updateTime) {
        this.setState(state, details, -1, -1, updateTime);
    }

    public void setState(String state, String details, int players, int maxPlayers, boolean updateTime) {
        if (this.core == null) {
            return;
        }
        if (this.enabled) {
            if (updateTime) {
                this.time = Instant.now();
            }
            Activity activity = new Activity();
            activity.setDetails(details.replace("%v", Pixelmon.getVersion()));
            activity.setState(state.replace("%v", Pixelmon.getVersion()));
            activity.timestamps().setStart(this.time);
            activity.party().size().setMaxSize(Math.max(maxPlayers, 1));
            activity.party().size().setCurrentSize(Math.max(players, 1));
            activity.assets().setLargeImage("main");
            activity.assets().setLargeText("discord.gg/pixelmon");
            activity.assets().setSmallImage("main");
            activity.assets().setSmallText("discord.gg/pixelmon");
            activity.addButton(new ActivityButton("Pixelmon Discord", "https://discord.gg/pixelmon"));
            if (!PixelmonServerConfig.getServerDiscord().getDiscordInvite().isBlank()) {
                String serverName = PixelmonServerConfig.getServerDiscord().getServerName();
                if (serverName.isBlank()) {
                    serverName = "My Minecraft Server!";
                }
                activity.addButton(new ActivityButton(serverName, PixelmonServerConfig.getServerDiscord().getDiscordInvite()));
            }
            activity.setActivityButtonsMode(ActivityButtonsMode.BUTTONS);
            this.core.activityManager().updateActivity(activity, result -> {
                if (result != Result.OK) {
                    Pixelmon.LOGGER.debug("Discord Rich Presence update result: {}", (Object)result);
                }
            });
        }
    }

    public void onJoin() {
        if (this.enabled) {
            this.THREAD_POOL.repeatUntilComplete(this::updateGameStateRichPresence, 15L, TimeUnit.SECONDS);
        }
    }

    private boolean updateGameStateRichPresence() {
        if (this.enabled) {
            IntegratedServer sp = Minecraft.m_91087_().m_91092_();
            ServerData mp = Minecraft.m_91087_().m_91089_();
            if (sp == null && mp == null) {
                return true;
            }
            if (sp != null && sp.m_6992_() || mp != null && mp.m_105389_()) {
                ClientProxy.getRichPresence().setState(NOSERVER_DETAIL, LOCAL_MULTIPLAYER, ClientStorageManager.pokedex.countCaught(), Pokedex.pokedexSize, false);
            } else if (sp != null && mp == null) {
                ClientProxy.getRichPresence().setState(NOSERVER_DETAIL, SINGLEPLAYER, ClientStorageManager.pokedex.countCaught(), Pokedex.pokedexSize, false);
            } else {
                int max;
                int players;
                try {
                    String status = ChatFormatting.m_126649_((String)mp.f_105364_.getString());
                    String[] split = status.split("/");
                    players = Integer.parseInt(split[0]);
                    max = Integer.parseInt(split[1]);
                }
                catch (Exception e) {
                    players = 0;
                    max = 0;
                }
                ClientProxy.getRichPresence().setState(SERVER_DETAIL.replace("%s", mp.f_105362_), MULTIPLAYER, players, max, false);
            }
        }
        return false;
    }

    public void poll() {
        if (this.core == null) {
            return;
        }
        try {
            if (this.enabled) {
                this.core.runCallbacks();
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Discord error", (Throwable)e);
        }
    }

    public void destruct() {
        if (this.core == null) {
            return;
        }
        if (this.enabled) {
            this.core.close();
            this.active = false;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isIniting() {
        return this.available && this.initing;
    }
}

