/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TileEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static boolean profileTileEntityRender = false;
    boolean blend = false;
    boolean disableCulling = false;
    boolean disableLighting = false;
    boolean flip = true;
    float scale = 0.0f;
    float yOffset = 0.0f;
    int correctionAngles = 0;
    boolean doProcessing = true;

    public TileEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T te, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (this.doProcessing) {
            int rotateDegrees = this.getRotation(te == null ? null : te.m_58900_());
            matrix.m_85836_();
            matrix.m_252880_(0.5f, this.yOffset, 0.5f);
            matrix.m_252781_(QuaternionHelper.fromEuler(rotateDegrees + this.correctionAngles, 0.0f, 1.0f, 0.0f));
            if (this.flip) {
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            }
            if (this.scale != 0.0f) {
                matrix.m_85841_(this.scale, this.scale, this.scale);
            }
        }
        this.render(te, te == null ? null : te.m_58900_(), te == null ? 0.0 : (double)te.m_58899_().m_123341_(), te == null ? 0.0 : (double)te.m_58899_().m_123342_(), te == null ? 0.0 : (double)te.m_58899_().m_123343_(), partialTicks, matrix, buffer, combinedLight, combinedOverlay);
        if (this.doProcessing) {
            matrix.m_85849_();
        }
    }

    public abstract void render(T var1, BlockState var2, double var3, double var5, double var7, float var9, PoseStack var10, MultiBufferSource var11, int var12, int var13);

    protected int getRotation(BlockState state) {
        if (state == null) {
            return 0;
        }
        Block block = state.m_60734_();
        if (block instanceof MultiBlock || block instanceof GenericRotatableModelBlock) {
            Direction facing;
            Direction direction = facing = block instanceof MultiBlock ? (Direction)state.m_61143_((Property)MultiBlock.FACING) : (Direction)state.m_61143_((Property)GenericRotatableModelBlock.FACING);
            if (facing == Direction.EAST) {
                return 270;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    public boolean hasProperty(BlockState state, Property<?> property) {
        return state.m_61147_().contains(property);
    }

    @Deprecated
    public void bindTexture(ResourceLocation texture) {
        Pixelmon.LOGGER.error("bindTexture call! Can't do this anymore! " + texture);
    }

    public VertexConsumer bindModelBuffer(MultiBufferSource buffer, Model model, ResourceLocation texture) {
        return buffer.m_6299_(model.m_103119_(texture));
    }

    public void renderModel(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderModel(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderModel(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(texture)), light, overlay, r, g, b, a);
    }

    public VertexConsumer bindSMDBuffer(MultiBufferSource buffer, ResourceLocation texture) {
        return buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture));
    }

    public void renderSMD(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderSMD(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderSMD(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        model.m_7695_(matrix, this.bindSMDBuffer(buffer, texture), light, overlay, r, g, b, a);
    }

    public void renderTransparentSMD(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        model.m_7695_(matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture)), light, overlay, r, g, b, a);
    }

    public void renderOBJ(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderOBJ(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderOBJ(PoseStack matrix, MultiBufferSource buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(texture)), light, overlay, r, g, b, a);
    }
}

