/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.listener.ZygardeCellsListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityZygardeCell
extends TileEntityRenderer<ZygardeCellTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> MODEL = new GenericModelHolder("blocks/cell/cell.pqc");
    private static final GenericModelHolder<GenericSmdModel> CORE = new GenericModelHolder("blocks/cell/core.pqc");
    private static final ResourceLocation ZYGARDE_CELL = ResourceLocationHelper.of("pixelmon", "textures/block/cell/zygarde_cell.png");
    private static final ResourceLocation ZYGARDE_CORE = ResourceLocationHelper.of("pixelmon", "textures/block/cell/zygarde_core.png");
    private static boolean clientHasCube = false;
    private static long clientLastCheck = 0L;

    public RenderTileEntityZygardeCell(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(ZygardeCellTileEntity te, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(player.m_5833_() || player.m_7500_() || RenderTileEntityZygardeCell.clientHasCube())) {
            return;
        }
        if (!(state.m_60734_() instanceof ZygardeCellBlock)) {
            return;
        }
        ResourceLocation texture = null;
        texture = state.m_60734_() == PixelmonBlocks.zygarde_cell ? ZYGARDE_CELL : ZYGARDE_CORE;
        ((GenericSmdModel)((Object)RenderTileEntityZygardeCell.CORE.getModel())).modelRenderer.setTransparent(0.8f);
        ((GenericSmdModel)((Object)RenderTileEntityZygardeCell.MODEL.getModel())).modelRenderer.setTransparent(0.8f);
        Direction orientation = (Direction)state.m_61143_((Property)ZygardeCellBlock.ORIENTATION_PROPERTY);
        if (orientation.m_122434_() != Direction.Axis.Y) {
            Direction rotation = (Direction)state.m_61143_((Property)ZygardeCellBlock.ROTATION_PROPERTY);
            matrix.m_85837_(0.0, -0.5, 0.0);
            matrix.m_252781_(QuaternionHelper.fromEuler(270.0f, rotation == Direction.UP ? 1.0f : -1.0f, 0.0f, 0.0f));
            if (rotation == Direction.DOWN) {
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            }
            matrix.m_85837_(0.0, 0.5, 0.0);
        } else if (orientation == Direction.UP) {
            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            matrix.m_252880_(0.0f, 1.0f, 0.0f);
        }
        float scale = 0.03f;
        matrix.m_85841_(scale, scale, scale);
        this.renderSMD(matrix, buffer, (Model)MODEL.getModel(), texture, combinedLight, combinedOverlay);
        matrix.m_85836_();
        matrix.m_252880_(0.0f, -5.0f, 0.0f);
        this.renderSMD(matrix, buffer, (Model)CORE.getModel(), texture, combinedLight, combinedOverlay);
        matrix.m_85849_();
    }

    @Override
    protected int getRotation(BlockState state) {
        if (this.hasProperty(state, (Property<?>)ZygardeCellBlock.ORIENTATION_PROPERTY) && this.hasProperty(state, (Property<?>)ZygardeCellBlock.ROTATION_PROPERTY)) {
            Direction orientation = (Direction)state.m_61143_((Property)ZygardeCellBlock.ORIENTATION_PROPERTY);
            Direction rotation = (Direction)state.m_61143_((Property)ZygardeCellBlock.ROTATION_PROPERTY);
            if (orientation.m_122434_() == Direction.Axis.Y) {
                if (rotation == Direction.EAST) {
                    return 270;
                }
                if (rotation == Direction.NORTH) {
                    return 0;
                }
                if (rotation == Direction.WEST) {
                    return 90;
                }
                if (rotation == Direction.SOUTH) {
                    return 180;
                }
            } else {
                if (orientation == Direction.EAST) {
                    return 270;
                }
                if (orientation == Direction.NORTH) {
                    return 0;
                }
                if (orientation == Direction.WEST) {
                    return 90;
                }
                if (orientation == Direction.SOUTH) {
                    return 180;
                }
            }
        }
        return 0;
    }

    private static boolean clientHasCube() {
        long time = System.currentTimeMillis();
        if (clientLastCheck < time - 1000L) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            clientHasCube = ZygardeCellsListener.checkForCube((Player)player);
            clientLastCheck = time;
        }
        return clientHasCube;
    }
}

