/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.TreeTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class RenderTileEntityTree
extends TileEntityRenderer<TreeTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> tree1 = new GenericModelHolder("pixelutilities/Tree/tree1.pqc");
    private static final GenericModelHolder<GenericSmdModel> tree2 = new GenericModelHolder("pixelutilities/Tree/tree2.pqc");
    private static final GenericModelHolder<GenericSmdModel> tree3 = new GenericModelHolder("pixelutilities/Tree/tree3.pqc");
    private static final GenericModelHolder<GenericSmdModel> tree4 = new GenericModelHolder("pixelutilities/Tree/tree4.pqc");
    private static final ResourceLocation texture1 = ResourceLocationHelper.of("pixelmon", "textures/block/trees/tree1.png");
    private static final ResourceLocation texture2 = ResourceLocationHelper.of("pixelmon", "textures/block/trees/tree2.png");
    private static final ResourceLocation texture3 = ResourceLocationHelper.of("pixelmon", "textures/block/trees/tree3.png");
    private static final ResourceLocation texture4 = ResourceLocationHelper.of("pixelmon", "textures/block/trees/tree4.png");

    public RenderTileEntityTree(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
    }

    @Override
    public void render(TreeTileEntity tree, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int treeType = tree.getTreeType();
        switch (treeType) {
            default: {
                tree.setTreeType(1);
            }
            case 1: {
                this.renderSMD(matrix, buffer, (Model)tree1.getModel(), texture1, combinedLight, combinedOverlay);
                break;
            }
            case 2: {
                this.renderSMD(matrix, buffer, (Model)tree2.getModel(), texture2, combinedLight, combinedOverlay);
                break;
            }
            case 3: {
                this.renderSMD(matrix, buffer, (Model)tree3.getModel(), texture3, combinedLight, combinedOverlay);
                break;
            }
            case 4: {
                this.renderSMD(matrix, buffer, (Model)tree4.getModel(), texture4, combinedLight, combinedOverlay);
            }
        }
    }
}

