/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.machines.TimespaceAltarBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.TimespaceAltarTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.client.particle.particles.SmallRising;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityTimespaceAltar
extends TileEntityRenderer<TimespaceAltarTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> lustrous_orb = new GenericModelHolder("blocks/shrines/timespace/lustrous_orb.pqc");
    private static final ResourceLocation lustrous_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/lustrous_orb.png");
    private static final GenericModelHolder<GenericSmdModel> adamant_orb = new GenericModelHolder("blocks/shrines/timespace/adamant_orb.pqc");
    private static final ResourceLocation adamant_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/adamant_orb.png");
    private static final GenericModelHolder<GenericSmdModel> griseous_orb = new GenericModelHolder("blocks/shrines/timespace/griseous_orb.pqc");
    private static final ResourceLocation griseous_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/griseous_orb.png");
    private double theta = 0.0;
    private PixelmonEntity pokemonToRender;

    public RenderTileEntityTimespaceAltar(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
    }

    @Override
    public void render(TimespaceAltarTileEntity shrineBlock, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        double zOffset;
        double xOffset;
        if (!(state.m_60734_() instanceof TimespaceAltarBlock)) {
            return;
        }
        matrix.m_85836_();
        Direction direction = (Direction)state.m_61143_((Property)TimespaceAltarBlock.FACING);
        if (direction == Direction.SOUTH) {
            xOffset = 0.5;
            zOffset = -4.5;
        } else if (direction == Direction.NORTH) {
            xOffset = 0.5;
            zOffset = 5.5;
        } else if (direction == Direction.WEST) {
            xOffset = 5.5;
            zOffset = 0.5;
        } else {
            xOffset = -4.5;
            zOffset = 0.5;
        }
        BlockPos center = new BlockPos((int)((double)shrineBlock.m_58899_().m_123341_() + xOffset), shrineBlock.m_58899_().m_123342_(), (int)((double)shrineBlock.m_58899_().m_123343_() + zOffset));
        if (shrineBlock.timeSpent > 0) {
            float gb2 = shrineBlock.flutePlayed ? 1.0f : Math.min(0.98f, (float)shrineBlock.timeSpent / 200.0f) + 0.02f;
            matrix.m_252880_(0.0f, (1.0f - (float)shrineBlock.timeSpent / 200.0f) * 5.0f, 0.0f);
            matrix.m_252880_(0.0f, (float)(-shrineBlock.timeSpent) / 200.0f * 5.0f, 0.0f);
            if (shrineBlock.flutePlayed) {
                matrix.m_85837_(0.0, 3.5, -5.0);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                pokemon = this.getPokemonToRender(PixelmonSpecies.ARCEUS.getValueUnsafe());
                pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), pokemon, false, partialTicks);
            } else {
                switch (shrineBlock.orbIn) {
                    case PALKIA: {
                        matrix.m_85837_(0.0, 3.5, -5.0);
                        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.PALKIA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), pokemon, false, partialTicks);
                        break;
                    }
                    case DIALGA: {
                        matrix.m_85837_(0.0, 3.0, -5.0);
                        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.DIALGA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), pokemon, false, partialTicks);
                        break;
                    }
                    case GIRATINA: {
                        matrix.m_252880_(0.0f, 4.0f, -5.0f);
                        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.GIRATINA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), pokemon, false, partialTicks);
                        break;
                    }
                }
            }
            int totalPoints = (int)((float)shrineBlock.timeSpent / 20.0f);
            for (int i = 0; i < totalPoints; ++i) {
                double pX = (double)shrineBlock.m_58899_().m_123341_() + xOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                double pZ = (double)shrineBlock.m_58899_().m_123343_() + zOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                Vec3i vec3i = new Vec3i((int)pX, shrineBlock.m_58899_().m_123342_(), (int)pZ);
                if (!(center.m_123331_(vec3i) < 16.0)) continue;
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ParticleArcanery(pX, shrineBlock.m_58899_().m_123342_(), pZ, 0.0, 1.0, 0.0, new SmallRising(1.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, 0.5f)));
            }
            ParticleSystems.get(1).execute(Minecraft.m_91087_(), (Level)Minecraft.m_91087_().f_91073_, (double)shrineBlock.m_58899_().m_123341_() + xOffset, (double)shrineBlock.m_58899_().m_123342_() + 0.5, (double)shrineBlock.m_58899_().m_123343_() + zOffset, 0.0f, false, shrineBlock.flutePlayed ? 1.0 : 0.0);
        } else if (shrineBlock.chainIn) {
            int totalPoints = 16;
            for (int i = 1; i <= totalPoints; ++i) {
                double theta = Math.PI * 2 / (double)totalPoints;
                double angle = theta * (double)i + this.theta;
                this.theta += 7.5E-4;
                if (this.theta > Math.PI) {
                    this.theta -= Math.PI;
                }
                double radius = 4.0;
                double dx = radius * Math.sin(angle);
                double dz = radius * Math.cos(angle);
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ParticleArcanery((double)shrineBlock.m_58899_().m_123341_() + xOffset + dx, (double)shrineBlock.m_58899_().m_123342_() + 0.5, (double)shrineBlock.m_58899_().m_123343_() + zOffset + dz, 0.0, 0.0, 0.0, new SmallRising(1.0f, 0.0f, 0.0f, 0.5f)));
            }
        }
        matrix.m_85849_();
    }

    private PixelmonEntity getPokemonToRender(Species species) {
        if (this.pokemonToRender == null || !this.pokemonToRender.getSpecies().is(species)) {
            Pokemon pokemon = PokemonFactory.create(species);
            pokemon.setShiny(false);
            pokemon.setGrowth(EnumGrowth.Ordinary);
            this.pokemonToRender = new PixelmonEntity((Level)Minecraft.m_91087_().f_91073_, pokemon);
        }
        return this.pokemonToRender;
    }
}

