/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.PokeChestBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityPokeChest
extends TileEntityRenderer<PokeChestTileEntity> {
    private static final ResourceLocation pokeball = ResourceLocationHelper.of("pixelmon", "textures/pokeballs/poke_ball.png");
    private static final ResourceLocation ultraball = ResourceLocationHelper.of("pixelmon", "textures/pokeballs/ultra_ball.png");
    private static final ResourceLocation masterball = ResourceLocationHelper.of("pixelmon", "textures/pokeballs/master_ball.png");
    private static final ResourceLocation beastball = ResourceLocationHelper.of("pixelmon", "textures/pokeballs/beast_ball.png");
    private static final ResourceLocation gsball = ResourceLocationHelper.of("pixelmon", "textures/pokeballs/gs_ball.png");
    private static final float SCALE = 0.0625f;

    public RenderTileEntityPokeChest(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.scale = 0.1f;
        this.yOffset = 0.03f;
        this.flip = false;
    }

    @Override
    public void render(PokeChestTileEntity chest, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (chest.getVisibility() == EnumPokechestVisibility.Hidden) {
            return;
        }
        PokeBall pokeball = chest.getChestType().getBall();
        GenericModelHolder<ModelPokeballs> modelHolder = pokeball.getModelHolder();
        ((ModelPokeballs)((Object)modelHolder.getModel())).theModel.setAnimation(AnimationType.IDLE);
        matrix.m_85841_(0.0625f, 0.0625f, 0.0625f);
        if (chest.getChestType() == EnumPokeChestType.MASTERBALL) {
            this.renderSMD(matrix, buffer, (Model)modelHolder.getModel(), masterball, combinedLight, combinedOverlay);
        } else if (chest.getChestType() == EnumPokeChestType.ULTRABALL) {
            this.renderSMD(matrix, buffer, (Model)modelHolder.getModel(), ultraball, combinedLight, combinedOverlay);
        } else if (chest.getChestType() == EnumPokeChestType.SPECIAL) {
            this.renderSMD(matrix, buffer, (Model)modelHolder.getModel(), gsball, combinedLight, combinedOverlay);
        } else if (chest.getChestType() == EnumPokeChestType.BEASTBALL) {
            this.renderSMD(matrix, buffer, (Model)modelHolder.getModel(), beastball, combinedLight, combinedOverlay);
        } else {
            this.renderSMD(matrix, buffer, (Model)modelHolder.getModel(), RenderTileEntityPokeChest.pokeball, combinedLight, combinedOverlay);
        }
    }

    @Override
    protected int getRotation(BlockState state) {
        if (state.m_60734_() instanceof PokeChestBlock) {
            Direction facing = (Direction)state.m_61143_((Property)PokeChestBlock.FACING);
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
            if (facing == Direction.EAST) {
                return 270;
            }
            return 0;
        }
        return 0;
    }
}

