/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.OrbBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.OrbTileEntity;
import com.pixelmonmod.pixelmon.client.models.obj.OBJLoader;
import com.pixelmonmod.pixelmon.client.models.obj.WavefrontObject;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.joml.Matrix4f;

public class RenderTileEntityOrb
extends TileEntityRenderer<OrbTileEntity> {
    public static final ResourceLocation RED_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/red_orb.png");
    public static final ResourceLocation BLUE_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/blue_orb.png");
    public static final ResourceLocation JADE_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/jade_orb.png");

    public RenderTileEntityOrb(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    @Override
    public boolean hasProperty(BlockState state, EnumProperty<?> property) {
        return state.m_61147_().contains(property);
    }

    @Override
    public void render(OrbTileEntity tile, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        byte pieces = tile.getPieces();
        if (!(state.m_60734_() instanceof OrbBlock)) {
            return;
        }
        if (!this.hasProperty(state, (EnumProperty<?>)OrbBlock.FACING)) {
            return;
        }
        EnumOrbShard shard = ((OrbBlock)state.m_60734_()).shardType;
        float scale = 1.0f;
        ResourceLocation rl = RED_ORB;
        switch (shard) {
            case RED: {
                rl = RED_ORB;
                scale = 0.13f;
                break;
            }
            case BLUE: {
                rl = BLUE_ORB;
                scale = 0.06f;
                break;
            }
            case JADE: {
                rl = JADE_ORB;
            }
        }
        matrix.m_85836_();
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        matrix.m_85841_(scale, scale, scale);
        this.renderOBJ(matrix, buffer, EnumOrbModels.getModel(shard, pieces), rl, combinedLight, combinedOverlay);
        matrix.m_85849_();
        if (tile.getPieces() > 9) {
            ++tile.clientTicker;
            float f = ((float)tile.clientTicker + partialTicks) / 300.0f;
            if (tile.clientTicker == Integer.MAX_VALUE) {
                tile.clientTicker = 0;
            }
            Random random = new Random(432L);
            matrix.m_85836_();
            scale = 3.5E-4f;
            int red = shard == EnumOrbShard.RED ? 255 : 0;
            int blue = shard == EnumOrbShard.BLUE ? 255 : 0;
            int green = shard == EnumOrbShard.JADE ? 255 : 0;
            matrix.m_85841_(scale, scale, scale);
            for (int i = 0; i < 3; ++i) {
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 1.0f, 0.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 0.0f, 1.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 1.0f, 0.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f + f * 90.0f, 0.0f, 0.0f, 1.0f));
                double f2 = (double)random.nextFloat() * 20.0 + 1.0 + 2000.0;
                double f3 = (double)random.nextFloat() * 2.0 + 1.0 + 400.0;
                VertexConsumer bufferbuilder = buffer.m_6299_(PixelmonRendering.triangleFan());
                Matrix4f pose = matrix.m_85850_().m_252922_();
                bufferbuilder.m_252986_(pose, 3.0f, 0.0f, 0.0f).m_6122_(red, green, blue, 191).m_5752_();
                bufferbuilder.m_252986_(pose, (float)(-3.0 * f3), (float)f2, (float)(-3.0 * f3)).m_6122_(red, green, blue, 0).m_5752_();
                bufferbuilder.m_252986_(pose, (float)(3.0 * f3), (float)f2, (float)(-3.0 * f3)).m_6122_(red, green, blue, 0).m_5752_();
                bufferbuilder.m_252986_(pose, 0.0f, (float)f2, (float)f3).m_6122_(red, green, blue, 1).m_5752_();
                bufferbuilder.m_252986_(pose, (float)(-3.0 * f3), (float)f2, (float)(-3.0 * f3)).m_6122_(red, green, blue, 0).m_5752_();
            }
            matrix.m_85849_();
        }
    }

    public static enum EnumOrbModels {
        RED_ONE("pixelmon:models/blocks/orbs/red/1.obj"),
        RED_TWO("pixelmon:models/blocks/orbs/red/2.obj"),
        RED_THREE("pixelmon:models/blocks/orbs/red/3.obj"),
        RED_FOUR("pixelmon:models/blocks/orbs/red/4.obj"),
        RED_FIVE("pixelmon:models/blocks/orbs/red/5.obj"),
        RED_SIX("pixelmon:models/blocks/orbs/red/6.obj"),
        RED_SEVEN("pixelmon:models/blocks/orbs/red/7.obj"),
        RED_EIGHT("pixelmon:models/blocks/orbs/red/8.obj"),
        RED_NINE("pixelmon:models/blocks/orbs/red/9.obj"),
        RED_TEN("pixelmon:models/blocks/orbs/red/10.obj"),
        BLUE_ONE("pixelmon:models/blocks/orbs/blue/1.obj"),
        BLUE_TWO("pixelmon:models/blocks/orbs/blue/2.obj"),
        BLUE_THREE("pixelmon:models/blocks/orbs/blue/3.obj"),
        BLUE_FOUR("pixelmon:models/blocks/orbs/blue/4.obj"),
        BLUE_FIVE("pixelmon:models/blocks/orbs/blue/5.obj"),
        BLUE_SIX("pixelmon:models/blocks/orbs/blue/6.obj"),
        BLUE_SEVEN("pixelmon:models/blocks/orbs/blue/7.obj"),
        BLUE_EIGHT("pixelmon:models/blocks/orbs/blue/8.obj"),
        BLUE_NINE("pixelmon:models/blocks/orbs/blue/9.obj"),
        BLUE_TEN("pixelmon:models/blocks/orbs/blue/10.obj"),
        JADE_ONE("pixelmon:models/blocks/orbs/jade/1.obj"),
        JADE_TWO("pixelmon:models/blocks/orbs/jade/2.obj"),
        JADE_THREE("pixelmon:models/blocks/orbs/jade/3.obj"),
        JADE_FOUR("pixelmon:models/blocks/orbs/jade/4.obj"),
        JADE_FIVE("pixelmon:models/blocks/orbs/jade/5.obj"),
        JADE_SIX("pixelmon:models/blocks/orbs/jade/6.obj"),
        JADE_SEVEN("pixelmon:models/blocks/orbs/jade/7.obj"),
        JADE_EIGHT("pixelmon:models/blocks/orbs/jade/8.obj"),
        JADE_NINE("pixelmon:models/blocks/orbs/jade/9.obj"),
        JADE_TEN("pixelmon:models/blocks/orbs/jade/10.obj");

        public WavefrontObject obj;
        public final ResourceLocation path;

        private EnumOrbModels(String path) {
            this.path = ResourceLocationHelper.of(path);
        }

        private WavefrontObject getModel() {
            if (this.obj == null) {
                try {
                    if (OBJLoader.accepts(this.path)) {
                        this.obj = OBJLoader.loadModel(this.path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.obj;
        }

        public static WavefrontObject getModel(EnumOrbShard shard, int pieces) {
            return EnumOrbModels.values()[shard.ordinal() * 10 + pieces - 1].getModel();
        }
    }
}

