/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MysteryBoxBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.MysteryBoxTileEntity;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityMysteryBox
extends TileEntityRenderer<MysteryBoxTileEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/entity/mystery_box/mystery_box.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE);
    private final ModelPart[] lid = new ModelPart[3];
    private final ModelPart[] bottom = new ModelPart[4];
    private final ModelPart[] tabs = new ModelPart[2];

    public RenderTileEntityMysteryBox(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.init();
    }

    public RenderTileEntityMysteryBox() {
        this(null);
    }

    private void init() {
        this.bottom[0] = RenderTileEntityMysteryBox.createBottom(0, 34, 1.0f, 0.0f, 1.0f, 14.0f, 5.0f, 14.0f, 0.0f).m_171564_();
        this.bottom[1] = RenderTileEntityMysteryBox.createBottom(56, 45, 6.0f, 5.0f, 5.0f, 4.0f, 7.0f, 6.0f, 0.0f).m_171564_();
        this.bottom[2] = RenderTileEntityMysteryBox.createBottom(0, 53, 1.0f, 5.0f, 1.0f, 5.0f, 7.0f, 14.0f, 0.0f).m_171564_();
        this.bottom[3] = RenderTileEntityMysteryBox.createBottom(38, 53, 10.0f, 5.0f, 1.0f, 5.0f, 7.0f, 14.0f, 0.0f).m_171564_();
        this.lid[0] = RenderTileEntityMysteryBox.createBottom(0, 0, -7.0f, 12.0f, -7.0f, 5.0f, 2.0f, 14.0f, 0.0f).m_171564_();
        this.lid[1] = RenderTileEntityMysteryBox.createBottom(0, 16, 2.0f, 12.0f, -7.0f, 5.0f, 2.0f, 14.0f, 0.0f).m_171564_();
        this.lid[2] = RenderTileEntityMysteryBox.createBottom(38, 26, -2.0f, 12.0f, -3.0f, 4.0f, 2.0f, 6.0f, 0.0f).m_171564_();
        this.lid[2].f_104202_ = 8.0f;
        this.lid[2].f_104200_ = 8.0f;
        this.lid[1].f_104202_ = 8.0f;
        this.lid[1].f_104200_ = 8.0f;
        this.lid[0].f_104202_ = 8.0f;
        this.lid[0].f_104200_ = 8.0f;
        this.tabs[0] = RenderTileEntityMysteryBox.createBottom(38, 0, 0.0f, 0.0f, -4.0f, 4.0f, 9.0f, 4.0f, 0.0f).m_171564_();
        this.tabs[0].f_104200_ = 6.0f;
        this.tabs[0].f_104201_ = 5.0f;
        this.tabs[0].f_104202_ = 15.0f;
        this.tabs[1] = RenderTileEntityMysteryBox.createBottom(38, 13, 0.0f, 0.0f, 0.0f, 4.0f, 9.0f, 4.0f, 0.0f).m_171564_();
        this.tabs[1].f_104200_ = 6.0f;
        this.tabs[1].f_104201_ = 5.0f;
        this.tabs[1].f_104202_ = 1.0f;
    }

    public static LayerDefinition createBottom(int xTextureOffset, int yTextureOffset, float x, float y, float z, float width, float height, float length, float deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        meshdefinition.m_171576_().m_171599_("root", CubeListBuilder.m_171558_().m_171514_(xTextureOffset, yTextureOffset).m_171525_("bottom", x, y, z, width, height, length, new CubeDeformation(deformation)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public void render(MysteryBoxTileEntity te, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level;
        Level level2 = level = te == null ? null : te.m_58904_();
        if (level == null || te.m_58900_().m_60734_() instanceof MysteryBoxBlock) {
            float[] fArray;
            matrix.m_85836_();
            if (level != null) {
                matrix.m_252781_(Axis.f_252436_.m_252977_(((Direction)te.m_58900_().m_61143_((Property)MysteryBoxBlock.FACING)).m_122435_()));
            }
            matrix.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrix.m_85837_(-0.5, 0.0, -0.5);
            VertexConsumer builder = buffer.m_6299_(RENDER_TYPE);
            if (te == null) {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            } else {
                fArray = te.getOpenness();
            }
            this.render(matrix, builder, fArray, combinedLight, combinedOverlay);
            matrix.m_85849_();
        }
    }

    private void render(PoseStack matrix, VertexConsumer builder, float[] openness, int combinedLight, int combinedOverlay) {
        this.lid[1].f_104201_ = this.lid[2].f_104201_ = 2.5f * Math.min(1.0f, openness[0]);
        this.lid[0].f_104201_ = this.lid[2].f_104201_;
        this.lid[1].f_104204_ = this.lid[2].f_104204_ = openness[1];
        this.lid[0].f_104204_ = this.lid[2].f_104204_;
        this.tabs[0].f_104203_ = 0.05f * openness[0];
        this.tabs[1].f_104203_ = -0.05f * openness[0];
        for (ModelPart lid : this.lid) {
            lid.m_104301_(matrix, builder, combinedLight, combinedOverlay);
        }
        for (ModelPart tabs : this.tabs) {
            tabs.m_104301_(matrix, builder, combinedLight, combinedOverlay);
        }
        for (ModelPart bottom : this.bottom) {
            bottom.m_104301_(matrix, builder, combinedLight, combinedOverlay);
        }
    }
}

