/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.blocks.machines.HealerBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.HealerTileEntity;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityHealer
extends TileEntityRenderer<HealerTileEntity> {
    public RenderTileEntityHealer(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
    }

    @Override
    public void render(HealerTileEntity healer, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (healer.stayDark) {
            healer.rotation = 0.0f;
        }
        if (healer.beingUsed) {
            for (int slot = 0; slot < healer.pokeballType.length; ++slot) {
                if (healer.pokeballType[slot] == null) continue;
                this.renderPokeball(matrix, buffer, combinedLight, combinedOverlay, slot, healer);
            }
        }
    }

    @Override
    protected int getRotation(BlockState state) {
        if (state.m_60734_() instanceof HealerBlock) {
            Direction facing = (Direction)state.m_61143_((Property)HealerBlock.FACING);
            if (facing == Direction.EAST) {
                return 270;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    private void renderPokeball(PoseStack matrix, MultiBufferSource buffer, int light, int overlay, int slot, HealerTileEntity tile) {
        matrix.m_85836_();
        float y = -0.77f;
        switch (slot) {
            case 0: {
                matrix.m_252880_(-0.155f, -0.77f, 0.25f);
                break;
            }
            case 1: {
                matrix.m_252880_(0.155f, -0.77f, 0.25f);
                break;
            }
            case 2: {
                matrix.m_252880_(-0.155f, -0.77f, 0.0f);
                break;
            }
            case 3: {
                matrix.m_252880_(0.155f, -0.77f, 0.0f);
                break;
            }
            case 4: {
                matrix.m_252880_(-0.155f, -0.77f, -0.25f);
                break;
            }
            case 5: {
                matrix.m_252880_(0.155f, -0.77f, -0.25f);
            }
        }
        float color = 1.0f;
        if (tile.allPlaced) {
            if (tile.flashTimer < 6 || tile.stayDark) {
                color = 0.3f;
            }
            if (tile.flashTimer >= 10) {
                tile.flashTimer = 0;
            }
        }
        GenericModelHolder<ModelPokeballs> pokeball = tile.pokeballType[slot].getModelHolder();
        matrix.m_252781_(QuaternionHelper.fromEuler(tile.rotation + 180.0f, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        ModelPokeballs model = (ModelPokeballs)((Object)pokeball.getModel());
        model.theModel.setAnimation(AnimationType.IDLE);
        matrix.m_85841_(0.0033333334f, 0.0033333334f, 0.0033333334f);
        this.renderSMD(matrix, buffer, (Model)model, tile.pokeballType[slot].getModelTexture(), light, overlay, color, color, color, 1.0f);
        matrix.m_85849_();
    }
}

