/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.GymSignTileEntity;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class RenderTileEntityGymSign
extends TileEntityRenderer<GymSignTileEntity> {
    public static final Vector3f ITEM_SCALE = new Vector3f(0.5f, 0.5f, 0.5f);
    public static final Vector3f FLOOR_POSITION_OFFSET = new Vector3f(0.0f, -0.5f, 0.2f);
    public static final Vector3f WALL_POSITION_OFFSET = new Vector3f(0.0f, -0.5f, 0.4f);
    public static final Vector3f HANGING_POSITION_OFFSET = new Vector3f(0.0f, -0.43f, 0.08f);
    public static final int FLOOR_ITEM_ROTATION = 23;
    public static final int FLIPPED_SPRITE_ROTATION = 180;

    public RenderTileEntityGymSign(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.disableCulling = true;
    }

    @Override
    public void render(GymSignTileEntity gymSign, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack itemstack = gymSign.getItemInSign();
        if (itemstack == null || itemstack.m_41619_()) {
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.WALL) {
            this.renderItemAtLocation(gymSign.m_58904_(), 0, matrix, buffer, combinedLight, WALL_POSITION_OFFSET, ITEM_SCALE, true, false, -1, itemstack);
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.FLOOR) {
            this.renderItemAtLocation(gymSign.m_58904_(), 0, matrix, buffer, combinedLight, new Vector3f(FLOOR_POSITION_OFFSET.x(), FLOOR_POSITION_OFFSET.y(), FLOOR_POSITION_OFFSET.z() + 0.03f), ITEM_SCALE, true, true, 23, itemstack);
            this.renderItemAtLocation(gymSign.m_58904_(), 0, matrix, buffer, combinedLight, new Vector3f(FLOOR_POSITION_OFFSET.x(), FLOOR_POSITION_OFFSET.y(), -FLOOR_POSITION_OFFSET.z()), ITEM_SCALE, true, false, 23, itemstack);
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.HANGING) {
            this.renderItemAtLocation(gymSign.m_58904_(), 0, matrix, buffer, combinedLight, HANGING_POSITION_OFFSET, ITEM_SCALE, true, true, -1, itemstack);
            this.renderItemAtLocation(gymSign.m_58904_(), 0, matrix, buffer, combinedLight, new Vector3f(HANGING_POSITION_OFFSET.x(), HANGING_POSITION_OFFSET.y(), -HANGING_POSITION_OFFSET.z()), ITEM_SCALE, true, false, -1, itemstack);
        }
    }

    private void renderItemAtLocation(Level level, int entityId, PoseStack matrix, MultiBufferSource buffer, int combinedLight, Vector3f position, Vector3f scale, boolean flipSprite, boolean rotateSprite, int rotation, ItemStack itemstack) {
        Minecraft mc = Minecraft.m_91087_();
        matrix.m_85836_();
        matrix.m_252880_(position.x(), position.y(), position.z());
        if (flipSprite) {
            matrix.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
        if (rotateSprite) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        if (rotation != -1) {
            matrix.m_252781_(Axis.f_252529_.m_252977_((float)rotation));
        }
        matrix.m_85841_(scale.x(), scale.y(), scale.z());
        mc.m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, combinedLight, OverlayTexture.f_118083_, matrix, buffer, level, entityId);
        matrix.m_85849_();
    }
}

