/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.IFrameCounter;
import com.pixelmonmod.pixelmon.blocks.tileentity.ISpecialTexture;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class RenderTileEntityGenericSMD<T extends BlockEntity>
extends TileEntityRenderer<T> {
    private GenericModelHolder<GenericSmdModel> holder;
    private ResourceLocation texture;
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f translate = new Vector3f(0.0f, 0.0f, 0.0f);

    public RenderTileEntityGenericSMD(BlockEntityRendererProvider.Context dispatcher, GenericModelHolder<GenericSmdModel> modelHolder, ResourceLocation texture) {
        super(dispatcher);
        this.holder = modelHolder;
        this.texture = texture;
    }

    public RenderTileEntityGenericSMD(BlockEntityRendererProvider.Context dispatcher, ResourceLocation model, ResourceLocation texture) {
        this(dispatcher, new GenericModelHolder<GenericSmdModel>(model), texture);
    }

    public RenderTileEntityGenericSMD(BlockEntityRendererProvider.Context dispatcher, String pqcPath, String texture) {
        this(dispatcher, ResourceLocationHelper.of("pixelmon", "models/" + pqcPath.toLowerCase(Locale.ROOT)), texture == null ? null : ResourceLocationHelper.of("pixelmon:textures/block/" + texture.toLowerCase(Locale.ROOT)));
    }

    @Override
    protected int getRotation(BlockState state) {
        return 0;
    }

    protected int getRotationSelf(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof MultiBlock || block instanceof GenericRotatableModelBlock) {
            Direction facing;
            Direction direction = facing = block instanceof MultiBlock ? (Direction)state.m_61143_((Property)MultiBlock.FACING) : (Direction)state.m_61143_((Property)GenericRotatableModelBlock.FACING);
            if (facing == Direction.EAST) {
                return 90;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 270;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    @Override
    public void render(T te, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation texture = te instanceof ISpecialTexture ? ((ISpecialTexture)te).getTexture() : this.texture;
        if (texture == null) {
            return;
        }
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture));
        GenericSmdModel model = (GenericSmdModel)((Object)this.holder.getModel());
        if (model.getModel() == null) {
            model.reloadModel();
        }
        if (te instanceof IFrameCounter) {
            model.setFrame(((IFrameCounter)te).getFrame());
        }
        matrix.m_85836_();
        matrix.m_252781_(QuaternionHelper.fromEuler(this.getRotationSelf(state), 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(this.angle, this.axis.x(), this.axis.y(), this.axis.z()));
        matrix.m_252880_(this.translate.x(), this.translate.y(), this.translate.z());
        matrix.m_85841_(model.getModel().getScale(), model.getModel().getScale(), model.getModel().getScale());
        model.render(matrix, vertices, combinedLight, combinedOverlay);
        matrix.m_85849_();
    }

    public RenderTileEntityGenericSMD<T> enableBlend() {
        this.blend = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> disableCulling() {
        this.disableCulling = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> disableLighting() {
        this.disableLighting = true;
        return this;
    }

    public RenderTileEntityGenericSMD<T> setCorrectionAngles(int correctionAngles) {
        this.correctionAngles = correctionAngles;
        return this;
    }

    public RenderTileEntityGenericSMD<T> setYOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public RenderTileEntityGenericSMD<T> rotate(float d, float axisX, float axisY, float axisZ) {
        this.angle = d;
        this.axis = new Vector3f(axisX, axisY, axisZ);
        return this;
    }

    public RenderTileEntityGenericSMD<T> translate(float x, float y, float z) {
        this.translate = new Vector3f(x, y, z);
        return this;
    }

    public RenderTileEntityGenericSMD<T> scale(float scale) {
        this.scale = scale;
        return this;
    }
}

