/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityGeneric<G extends RenderTileEntityGeneric<G, T>, T extends BlockEntity>
extends TileEntityRenderer<T> {
    protected ResourceLocation texture;
    public Model model;
    public HashMap<GenericSmdModel, ResourceLocation> childModels = Maps.newHashMap();
    protected int correctionAngles = 0;
    protected int rotateDegrees = 0;
    protected float scale = 0.0f;
    protected float yOffset = 0.0f;
    public boolean blend = false;
    public boolean disableCulling = false;
    public boolean disableLighting = false;

    public RenderTileEntityGeneric(BlockEntityRendererProvider.Context dispatcher, String textureFileName, Model model) {
        super(dispatcher);
        this.texture = ResourceLocationHelper.of("pixelmon:textures/block/" + textureFileName.toLowerCase(Locale.ROOT));
        this.model = model;
    }

    public RenderTileEntityGeneric(String modId, BlockEntityRendererProvider.Context dispatcher, String textureFileName, Model model, int correctionAngles) {
        super(dispatcher);
        this.texture = ResourceLocationHelper.of(modId, "textures/block/" + textureFileName.toLowerCase(Locale.ROOT));
        this.model = model;
        this.correctionAngles = correctionAngles;
    }

    public RenderTileEntityGeneric(BlockEntityRendererProvider.Context dispatcher, String textureFileName, Model model, int correctionAngles) {
        this("pixelmon", dispatcher, textureFileName, model, correctionAngles);
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public void render(T te, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing;
        VertexConsumer vertexBuffer = buffer.m_6299_(RenderType.m_110466_());
        Block block = state.m_60734_();
        this.rotateDegrees = block instanceof MultiBlock || block instanceof GenericRotatableModelBlock ? ((facing = block instanceof MultiBlock ? (Direction)state.m_61143_((Property)MultiBlock.FACING) : (Direction)state.m_61143_((Property)GenericRotatableModelBlock.FACING)) == Direction.EAST ? 270 : (facing == Direction.NORTH ? 0 : (facing == Direction.WEST ? 90 : (facing == Direction.SOUTH ? 180 : 0)))) : 0;
        matrix.m_85836_();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.depthMask((boolean)false);
        }
        matrix.m_252880_(0.5f, this.yOffset, 0.5f);
        matrix.m_252781_(QuaternionHelper.fromEuler(this.rotateDegrees + this.correctionAngles, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        if (this.scale != 0.0f) {
            matrix.m_85841_(this.scale, this.scale, this.scale);
        }
        this.renderSMD(matrix, buffer, this.model, this.texture, combinedLight, combinedOverlay);
        for (Map.Entry<GenericSmdModel, ResourceLocation> childEntry : this.childModels.entrySet()) {
            this.renderSMD(matrix, buffer, childEntry.getKey(), childEntry.getValue(), combinedLight, combinedOverlay);
        }
        if (this.blend) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
        matrix.m_85849_();
    }
}

